/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.settings;

import de.maggicraft.mcommons.event.IObserver;
import de.maggicraft.mcommons.settings.ISetting;
import de.maggicraft.mioutil.json.IUniqueID;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public abstract class MBaseSetting<V>
implements ISetting<V> {
    @NotNull
    protected final IUniqueID<String> mUID;
    @NotNull
    private final List<IObserver<ISetting<V>>> mObservers = new LinkedList<IObserver<ISetting<V>>>();
    @NotNull
    private final V mDefaultValue;
    @NotNull
    protected V mValue;

    public MBaseSetting(@NotNull IUniqueID<String> pUID, @NotNull V pDefaultValue) {
        this.mUID = pUID;
        this.mDefaultValue = pDefaultValue;
        this.mValue = pDefaultValue;
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        MBaseSetting that = (MBaseSetting)pO;
        return this.mUID.equals(that.mUID);
    }

    public int hashCode() {
        return Objects.hash(this.mUID);
    }

    @Override
    public boolean setValue(@NotNull V pValue) {
        boolean changed = !this.isSameValue(pValue);
        this.mValue = pValue;
        if (changed) {
            this.notifyObservers(this);
        }
        return changed;
    }

    @Override
    public boolean setDefaultValue() {
        return this.setValue(this.mDefaultValue);
    }

    @Override
    public boolean isDefaultValue() {
        return this.isSameValue(this.mDefaultValue);
    }

    @Override
    public boolean isSameValue(@NotNull V pValue) {
        return this.mValue.equals(pValue);
    }

    @Override
    public void toJSON(@NotNull JSONObject pJSON) {
        pJSON.put(this.mUID.getUID(), this.mValue);
    }

    @Override
    @NotNull
    public List<IObserver<ISetting<V>>> getListeners() {
        return this.mObservers;
    }

    @Override
    @NotNull
    public IUniqueID<String> getUID() {
        return this.mUID;
    }

    @Override
    @NotNull
    public V getValue() {
        return this.mValue;
    }

    @Override
    @NotNull
    public V getDefaultValue() {
        return this.mDefaultValue;
    }
}

