/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.settings;

import de.maggicraft.mcommons.settings.MBaseSetting;
import de.maggicraft.mioutil.json.IUniqueID;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class MListSetting
extends MBaseSetting<String> {
    private String[] mOptions;

    public MListSetting(@NotNull IUniqueID<String> pUID, @NotNull String pDefaultValue, String ... pOptions) {
        super(pUID, pDefaultValue);
        if (pOptions.length == 0) {
            throw new IllegalArgumentException("empty list");
        }
        if (!MListSetting.containsValue(pOptions, pDefaultValue)) {
            throw new IllegalArgumentException("default value not in options");
        }
        this.mOptions = pOptions;
    }

    public static boolean containsValue(String[] pOptions, String pValue) {
        for (String option : pOptions) {
            if (!option.equals(pValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean fromJSON(@NotNull JSONObject pJSON) {
        if (pJSON.containsKey(this.mUID.getUID())) {
            String readOption = (String)pJSON.get(this.mUID.getUID());
            if (MListSetting.containsValue(this.mOptions, readOption)) {
                return this.setValue(readOption);
            }
            return true;
        }
        return true;
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.mOptions.length; ++i) {
            if (!this.isSelected(this.mOptions[i])) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public boolean isSelected(String pOption) {
        return pOption.equals(this.mValue);
    }

    public String[] getOptions() {
        return this.mOptions;
    }
}

