/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.settings;

import de.maggicraft.mcommons.settings.ISetting;
import de.maggicraft.mcommons.settings.IStorableSettings;
import de.maggicraft.mioutil.io.MIOUtil;
import de.maggicraft.mlog.MLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MStorableSettings
implements IStorableSettings {
    @NotNull
    private final Set<ISetting> mSettings;
    @NotNull
    private final File mFile;
    private boolean mStorable = true;

    public MStorableSettings(@NotNull File pFile, ISetting ... pSettings) {
        this(pFile, Arrays.asList(pSettings));
    }

    public MStorableSettings(@NotNull File pFile, Collection<ISetting> pSettings) {
        this.mSettings = Collections.unmodifiableSet(new HashSet<ISetting>(pSettings));
        for (ISetting setting : pSettings) {
            setting.registerObserver(pEvent -> this.store());
        }
        this.mFile = pFile;
        if (this.mSettings.isEmpty()) {
            throw new IllegalArgumentException("empty set of settings");
        }
        if (this.mFile.exists()) {
            this.read();
        }
    }

    @Override
    public boolean setDefaultValues() {
        this.mStorable = false;
        boolean changed = false;
        for (ISetting setting : this.mSettings) {
            changed |= setting.setDefaultValue();
        }
        this.mStorable = true;
        if (changed) {
            this.store();
        }
        return changed;
    }

    @Override
    public boolean isDefaultValues() {
        for (ISetting setting : this.mSettings) {
            if (setting.isDefaultValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void store() {
        if (this.mStorable) {
            JSONObject json = this.toJSON();
            MIOUtil.write(this.mFile, json.toJSONString());
        }
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        for (ISetting setting : this.mSettings) {
            setting.toJSON(json);
        }
        return json;
    }

    @Override
    public void read() {
        try {
            JSONObject json = (JSONObject)new JSONParser().parse(new BufferedReader(new FileReader(this.mFile)));
            this.fromJSON(json);
        }
        catch (IOException | ParseException pE) {
            MLog.log(pE);
        }
    }

    @Override
    public void fromJSON(@NotNull JSONObject pJSON) {
        this.mStorable = false;
        boolean changed = false;
        for (ISetting setting : this.mSettings) {
            changed |= setting.fromJSON(pJSON);
        }
        this.mStorable = true;
        if (changed) {
            this.store();
        }
    }

    @Override
    @NotNull
    public Set<ISetting> getSettings() {
        return this.mSettings;
    }

    @Override
    @NotNull
    public File getFile() {
        return this.mFile;
    }

    public boolean isStorable() {
        return this.mStorable;
    }
}

