/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.state_machine;

import de.maggicraft.mcommons.state_machine.IState;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public interface IStateMachine<E extends IState>
extends Serializable {
    default public void check(@NotNull E pRequired) {
        if (this.getState() != pRequired) {
            throw new IllegalStateException("required state \"" + (String)pRequired.getUID() + "\", but \"" + (String)this.getState().getUID() + "\" is the current state");
        }
    }

    default public void check(E ... pRequired) {
        boolean valid = false;
        for (E required : pRequired) {
            if (required != this.getState()) continue;
            valid = true;
            break;
        }
        if (!valid) {
            StringBuilder sb = new StringBuilder("required state ");
            for (int i = 0; i < pRequired.length; ++i) {
                if (i > 0) {
                    sb.append(" or ");
                }
                sb.append('\"').append((String)pRequired[i].getUID()).append('\"');
            }
            sb.append(", but \"").append((String)this.getState().getUID()).append(" is the current state");
            throw new IllegalStateException(sb.toString());
        }
    }

    @NotNull
    public IState getState();
}

