/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.timer;

import de.maggicraft.mcommons.state_machine.IState;
import de.maggicraft.mcommons.timer.ETimerStates;
import de.maggicraft.mcommons.timer.ITimer;
import org.jetbrains.annotations.NotNull;

public class Timer
implements ITimer {
    @NotNull
    private ETimerStates mState = ETimerStates.INITIALIZED;
    private long mTime = 0L;
    private long mCurrentTime = 0L;

    private static long currentTime() {
        return System.currentTimeMillis();
    }

    @Override
    @NotNull
    public Timer startTimer() {
        this.check(ETimerStates.INITIALIZED);
        this.mState = ETimerStates.RUNNING;
        this.mCurrentTime = Timer.currentTime();
        return this;
    }

    @Override
    public void pauseTimer() {
        this.check(ETimerStates.RUNNING);
        this.mState = ETimerStates.PAUSED;
        this.mTime += Timer.currentTime() - this.mCurrentTime;
        this.mCurrentTime = 0L;
    }

    @Override
    public void resumeTimer() {
        this.check(ETimerStates.PAUSED);
        this.mState = ETimerStates.RUNNING;
        this.mCurrentTime = Timer.currentTime();
    }

    @Override
    public void stopTimer() {
        this.check(ETimerStates.RUNNING);
        this.mState = ETimerStates.STOPPED;
        this.mTime += Timer.currentTime() - this.mCurrentTime;
        this.mCurrentTime = 0L;
    }

    @Override
    public long getTime() {
        return this.mTime;
    }

    @Override
    @NotNull
    public IState getState() {
        return this.mState;
    }
}

