/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mcommons.util;

import de.maggicraft.mlog.MLog;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CommonUtil {
    private static int sStacktrace = 0;
    private static String sDecimalMark = ",";

    private CommonUtil() {
    }

    public static void stacktrace(String pName) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder().append(sStacktrace++).append('\t').append(pName).append('\t');
        for (int i = 2; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            sb.append(element.getClassName().replaceAll(".*\\..*\\.", "")).append('.').append(element.getMethodName()).append(':').append(element.getLineNumber()).append('\t');
        }
        MLog.log(pName);
    }

    @Contract(pure=true)
    public static int getMax(@NotNull List<Integer> pList) {
        int max = Integer.MIN_VALUE;
        for (Integer integer : pList) {
            if (integer <= max) continue;
            max = integer;
        }
        return max;
    }

    @Contract(pure=true)
    public static int getMax(int ... pInts) {
        int max = Integer.MIN_VALUE;
        for (int i : pInts) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    @NotNull
    public static String decMark(int pDec) {
        return (pDec < 0 ? "-" : "") + CommonUtil.decMark(Integer.toString(Math.abs(pDec)));
    }

    @NotNull
    public static String decMark(@NotNull String pDec) {
        int len = pDec.length();
        String str = "";
        for (int i = len - 1; i >= 0; --i) {
            str = pDec.charAt(i) + str;
            if ((len - i) % 3 != 0 || i == 0) continue;
            str = sDecimalMark + str;
        }
        return str;
    }

    public static void sleep(long pMillis) {
        try {
            Thread.sleep(pMillis);
        }
        catch (InterruptedException pE) {
            pE.printStackTrace();
        }
    }

    public static void setDecimalMark(String pDecimalMark) {
        sDecimalMark = pDecimalMark;
    }
}

