/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.listener.IAction;
import de.maggicraft.mgui.listener.IListenable;
import de.maggicraft.mgui.listener.IListener;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.listener.MListener;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.jetbrains.annotations.NotNull;

public class MCombo
extends JComboBox
implements IComp,
ITippable,
IListenable<ItemListener, Integer, ItemEvent> {
    public static final int EXT_WIDTH = 45;
    public static final int EXT_HEIGHT = 8;
    private static final int LISTENERS_ENABLED = 1;
    private static final int LAST_INCLUDE = 2;
    @NotNull
    private final MMPos mPos;
    private List<IListener<ItemListener, Integer, ItemEvent>> mListeners = new LinkedList<IListener<ItemListener, Integer, ItemEvent>>();
    private String[] mLangKeys;
    private String[] mTexts;
    private MTip mTip;
    private int mSearchBar;

    public MCombo(@NotNull MMPos pPos) {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent pEvent) {
            }

            @Override
            public void focusGained(FocusEvent pEvent) {
                MCombo.this.showPopup();
            }
        });
        MCon.styleCombo(this);
        this.updateColor();
        pPos.addComp(this);
        this.mPos = pPos;
        this.updatePrefHeight();
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public static MCombo retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MCombo)MReflection.retrieveComp(pView, pPath, MCombo.class);
    }

    @NotNull
    public MCombo addSearchBar(@NotNull MField pField) {
        return this.addSearchBar(pField, true);
    }

    @NotNull
    public MCombo addSearchBar(final @NotNull MField pField, boolean pWrongInput) {
        this.mSearchBar |= 1;
        pField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent pEvent) {
                if ((MCombo.this.mSearchBar & 1) != 0) {
                    MCombo.this.hidePopup();
                    Object selectedItem = MCombo.this.getSelectedItem();
                    if (selectedItem != null) {
                        pField.setText(selectedItem.toString());
                    }
                }
            }

            @Override
            public void focusGained(FocusEvent pEvent) {
                if ((MCombo.this.mSearchBar & 1) != 0) {
                    MCombo.this.showPopup();
                }
            }
        });
        pField.addListener(pEvent -> {
            if ((this.mSearchBar & 1) != 0) {
                int selection = this.search(pField.getText());
                if (selection == -1) {
                    this.mSearchBar &= 0xFFFFFFFD;
                    if (pWrongInput) {
                        pField.setBorder(MCon.borderFieldWrongInput());
                    }
                } else {
                    if ((this.mSearchBar & 2) == 0) {
                        this.mSearchBar |= 2;
                        if (pWrongInput) {
                            pField.setBorder(MCon.borderFieldFocus());
                        }
                    }
                    this.mSearchBar &= 0xFFFFFFFE;
                    this.setSelectedIndex(selection);
                    this.mSearchBar |= 1;
                }
            }
        });
        this.addListener(pEvent -> {
            if ((this.mSearchBar & 1) != 0) {
                this.mSearchBar &= 0xFFFFFFFE;
                Object selectedItem = this.getSelectedItem();
                if (selectedItem != null) {
                    pField.setText(selectedItem.toString());
                }
                this.mSearchBar |= 1;
            }
        });
        return this;
    }

    public void setEnabledInterval(int pFrom, int pTo) {
        if (!(this.getRenderer() instanceof MEnabledComboRenderer)) {
            this.setRenderer(new MEnabledComboRenderer());
        }
        ((MEnabledComboRenderer)this.getRenderer()).setSelectionInterval(pFrom, pTo);
    }

    @Override
    public void setSelectedIndex(int pIndex) {
        if (this.getRenderer() instanceof MEnabledComboRenderer && !((MEnabledComboRenderer)this.getRenderer()).isSelectable(pIndex)) {
            return;
        }
        super.setSelectedIndex(pIndex);
    }

    public int search(@NotNull String pText) {
        String text = pText.toLowerCase();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            if (!this.getModel().getElementAt(i).toString().toLowerCase().startsWith(text)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateColor() {
        MCon.getSchemeMisc().initComboStyle();
        this.setForeground(MCon.colorComboText());
        this.setBackground(MCon.colorComboBackground());
    }

    @Override
    public void updateLang() {
        if (this.mLangKeys != null) {
            this.title(this.mLangKeys);
        }
    }

    @Override
    @NotNull
    public MCombo title(@NotNull String pTitle) {
        return this.title(new String[]{pTitle});
    }

    @NotNull
    public MCombo title(String ... pTitles) {
        this.mLangKeys = pTitles;
        this.setName(pTitles[0]);
        return this.text(MLangManager.prefix("co.", pTitles));
    }

    @Override
    @NotNull
    public MCombo text(@NotNull String pText) {
        return this.text(new String[]{pText});
    }

    @NotNull
    public MCombo text(String ... pTexts) {
        this.mTexts = pTexts;
        this.setModel((ComboBoxModel)new DefaultComboBoxModel<String>(pTexts));
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MCombo name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    @NotNull
    public String getLangKey() {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MCombo tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MCombo title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mTip = pTip;
        this.setName(pTitle);
        pTip.tip(this, "co.tt." + pTitle);
        return this;
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    public void setModel(ComboBoxModel pModel) {
        super.setModel(pModel);
        this.prefWidth();
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
    }

    @Override
    public int prefWidth() {
        if (this.mTexts != null && this.getModel() instanceof DefaultComboBoxModel) {
            return Util.getWidth(MCon.fontCombo(), this.mTexts) + 45;
        }
        return 45;
    }

    @Override
    public int prefHeight() {
        return Util.getMetrics(this.getFont()).getHeight() + 8;
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    public int getPrefHeight() {
        return this.mPos.getPrefHeight();
    }

    public String[] getLangKeys() {
        return this.mLangKeys;
    }

    public String[] getTexts() {
        return this.mTexts;
    }

    public MCombo addListener(IAction<ItemEvent> pAction) {
        return this.addListener((IListener)new MListener(pAction));
    }

    public MCombo addListener(IAction<ItemEvent> pAction, boolean pFireOnce) {
        return this.addListener((IListener)new MListener(pAction, pFireOnce));
    }

    public MCombo addListener(IListener<ItemListener, Integer, ItemEvent> pListener) {
        this.mListeners.add(pListener);
        ItemListener listener = pEvent -> {
            if (pEvent.getStateChange() == 2) {
                pListener.action(this.getSelectedIndex(), pEvent);
            }
        };
        this.addItemListener(listener);
        return this;
    }

    @Override
    public void valueVoid(Integer pValue) {
        this.setSelectedIndex(pValue);
    }

    @Override
    public void removeParentListener(IListener<ItemListener, Integer, ItemEvent> pListener) {
        this.removeItemListener(pListener.getParentListener());
    }

    @Override
    public List<IListener<ItemListener, Integer, ItemEvent>> getListeners() {
        return this.mListeners;
    }

    private static class MEnabledComboRenderer
    extends BasicComboBoxRenderer {
        @NotNull
        private final ListSelectionModel mEnabledItems = new DefaultListSelectionModel();

        public MEnabledComboRenderer() {
            this.setBorder(new EmptyBorder(0, 5, 0, 5));
        }

        public void setSelectionInterval(int pFrom, int pTo) {
            this.mEnabledItems.setSelectionInterval(pFrom, pTo);
        }

        @Override
        public Component getListCellRendererComponent(@NotNull JList pList, Object pValue, int pIndex, boolean pIsSelected, boolean pCellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)pList, pValue, pIndex, pIsSelected, pCellHasFocus);
            if (this.mEnabledItems.isSelectedIndex(pIndex)) {
                comp.setBackground(this.getBackground());
                comp.setForeground(this.getForeground());
            } else {
                comp.setBackground(MCon.colorComboBackgroundDisabled());
                comp.setForeground(MCon.colorText());
            }
            return comp;
        }

        public boolean isSelectable(int pIndex) {
            return this.mEnabledItems.isSelectedIndex(pIndex);
        }
    }
}

