/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mgui.comp.ICoordEvent;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MCoord
extends MPanel {
    private static final Color COLOR_TEXT = MCon.colorText();
    private static final Color COLOR_GRID = COLOR_TEXT.darker().darker();
    private static final Color COLOR_PADDING = MCon.colorFrame().brighter();
    private static final Color COLOR_BACKGROUND = MCon.colorFrame();
    private static final int PADDING = 15;
    private static String[] sLabelsXPos = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private static String[] sLabelsYPos = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private static String[] sLabelsXNeg = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
    private static String[] sLabelsYNeg = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
    @NotNull
    private final LinkedList<ICoordEvent> mClickEvents = new LinkedList();
    private float mPointRelX;
    private float mPointRelY;

    public MCoord(@NotNull MMPos pPos) {
        super(pPos);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent pE) {
                int x = pE.getX();
                int y = pE.getY();
                int width = MCoord.this.getWidth() - 30;
                int height = MCoord.this.getHeight() - 30;
                if (x <= 15 || x >= MCoord.this.getWidth() - 15) {
                    return;
                }
                if (y <= 15 || y >= MCoord.this.getHeight() - 15) {
                    return;
                }
                int transX = width / 2 - x + 15;
                float relX = (float)(transX * -1) / ((float)width / 2.0f);
                int transY = height / 2 - y + 15;
                float relY = (float)transY / ((float)height / 2.0f);
                for (ICoordEvent clickEvent : MCoord.this.mClickEvents) {
                    clickEvent.click(relX, relY);
                }
            }
        });
        MCompListeners.compInitialized(this);
    }

    @Override
    protected void paintComponent(Graphics pG) {
        Graphics2D g2 = (Graphics2D)pG;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double middleX = (double)this.getWidth() / 2.0;
        double middleY = (double)this.getHeight() / 2.0;
        int width = this.getWidth() - 30;
        int height = this.getHeight() - 30;
        g2.setColor(COLOR_PADDING);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(COLOR_BACKGROUND);
        g2.fillRect(15, 15, width, height);
        g2.setColor(COLOR_GRID);
        g2.drawLine(15, (int)middleY, this.getWidth() - 15, (int)middleY);
        g2.drawLine((int)middleX, 15, (int)middleX, this.getHeight() - 15);
        FontMetrics metrics = g2.getFontMetrics();
        double scaleX = (double)width / (double)sLabelsXPos.length;
        for (int i = 1; i < sLabelsXPos.length + 1; ++i) {
            g2.setColor(COLOR_GRID);
            int x0 = (int)(middleX + (double)i * scaleX / 2.0);
            g2.drawLine(x0, (int)middleY - 3, x0, (int)middleY + 3);
            int x1 = (int)(middleX - (double)i * scaleX / 2.0);
            g2.drawLine(x1, (int)middleY - 3, x1, (int)middleY + 3);
            g2.setColor(COLOR_TEXT);
            g2.drawString(sLabelsXPos[i - 1], (float)x0 - (float)metrics.stringWidth(sLabelsXPos[i - 1]) / 2.0f, (float)middleY + 15.0f);
            g2.drawString(sLabelsXNeg[i - 1], (float)x1 - (float)metrics.stringWidth(sLabelsXNeg[i - 1]) / 2.0f, (float)middleY + 15.0f);
        }
        double scaleY = (double)height / (double)sLabelsYPos.length;
        for (int i = 1; i < sLabelsYPos.length + 1; ++i) {
            g2.setColor(COLOR_GRID);
            int y0 = (int)(middleY + (double)i * scaleY / 2.0);
            g2.drawLine((int)middleX - 3, y0, (int)middleX + 3, y0);
            int y1 = (int)(middleY - (double)i * scaleY / 2.0);
            g2.drawLine((int)middleX - 3, y1, (int)middleX + 3, y1);
            g2.setColor(COLOR_TEXT);
            g2.drawString(sLabelsYNeg[i - 1], (float)middleX - (float)metrics.stringWidth(sLabelsYNeg[i - 1]) - 5.0f, (float)y0 + (float)metrics.getHeight() / 2.0f - 3.0f);
            g2.drawString(sLabelsYPos[i - 1], (float)middleX - (float)metrics.stringWidth(sLabelsYPos[i - 1]) - 5.0f, (float)y1 + (float)metrics.getHeight() / 2.0f - 3.0f);
        }
        if (-1.0f <= this.mPointRelX && this.mPointRelX <= 1.0f && -1.0f <= this.mPointRelY && this.mPointRelY <= 1.0f) {
            int x = (int)(this.mPointRelX * (float)width / 2.0f + (float)width / 2.0f + 15.0f) - 3;
            int y = (int)(-this.mPointRelY * (float)height / 2.0f + (float)height / 2.0f + 15.0f) - 3;
            g2.setColor(MCon.colorAccent());
            g2.fillOval(x, y, 6, 6);
        }
    }

    public void addCoordListener(ICoordEvent pCoordEvent) {
        this.mClickEvents.add(pCoordEvent);
    }

    public void drawPoint(float pRelX, float pRelY) {
        this.mPointRelX = pRelX;
        this.mPointRelY = pRelY;
        this.invalidate();
        this.repaint();
    }

    public void updateLabels(double pMaxValue) {
        String[][] labels = MCoord.generateLabels(pMaxValue, 10);
        sLabelsXPos = labels[0];
        sLabelsYPos = labels[0];
        sLabelsXNeg = labels[1];
        sLabelsYNeg = labels[1];
        this.invalidate();
        this.repaint();
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static String[][] generateLabels(double pMaxValue, int pSteps) {
        String[] posAxes = new String[pSteps];
        String[] negAxes = new String[pSteps];
        for (int i = 0; i < pSteps; ++i) {
            double value = (double)Math.round(((double)i + 1.0) / (double)pSteps * pMaxValue * 100.0) / 100.0;
            posAxes[i] = Double.toString(value);
            negAxes[i] = "-" + value;
        }
        return new String[][]{posAxes, negAxes};
    }

    public float getPosX() {
        return this.mPointRelX;
    }

    public float getPosY() {
        return this.mPointRelY;
    }

    @NotNull
    public static MCoord retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MCoord)MReflection.retrieveComp(pView, pPath, MCoord.class);
    }
}

