/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

public class MEditor
extends JEditorPane
implements IComp,
ITippable {
    @NotNull
    private final MMPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MEditor(@NotNull MMPos pPos) {
        MCon.styleEditor(this);
        this.addHyperlinkListener(pEvent -> {
            String desc;
            if (pEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !(desc = pEvent.getDescription()).startsWith("mgui")) {
                Util.openURL(desc);
            }
        });
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public MEditor rep(@NotNull String pTitle, Object ... pReplace) {
        this.mLangKey = pTitle;
        this.setName(pTitle);
        this.text(MLangManager.rep("ed." + pTitle, pReplace));
        return this;
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorText());
        this.setBackground(MCon.colorTextBackground());
        MEditor.editorCSS(this);
    }

    public static void editorCSS(@NotNull JEditorPane pEditor) {
        StyleSheet style = ((HTMLDocument)pEditor.getDocument()).getStyleSheet();
        StringBuilder rules = new StringBuilder().append("body {").append(MEditor.toCSSColor(MCon.colorEditorPaneForeground())).append(MEditor.toCSSFont(MCon.fontEditor())).append("} a {").append(MEditor.toCSSColor(MCon.colorAccent())).append("font-weight: bold; }");
        style.addRule(rules.toString());
    }

    @NotNull
    public static String toCSSColor(@NotNull Color pColor) {
        return "color: rgb(" + pColor.getRed() + ',' + pColor.getGreen() + ',' + pColor.getBlue() + ");";
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    @NotNull
    public static String toCSSFont(@NotNull Font pFont) {
        return "font-family: " + pFont.getFamily() + "; font-size: " + pFont.getSize() + "pt;";
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.setText(MLangManager.get("ed." + this.mLangKey));
            if (this.mPos.isPrefH()) {
                this.mPos.setPrefWidth(this.prefWidth());
            }
            if (this.mTip != null) {
                this.mTip.updateLang(this, "ed.tt." + this.mLangKey);
            }
        }
    }

    @Override
    @NotNull
    public MEditor title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setText(MLangManager.get("ed." + pTitle));
        this.setName(pTitle);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MEditor text(@NotNull String pText) {
        this.setText(pText);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MEditor name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MEditor tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MEditor title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this, "ed.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public int prefWidth() {
        return MEditor.getPrefWidth(this.getText());
    }

    public static int getPrefWidth(@NotNull String pText) {
        String[] lines;
        if (pText.isEmpty()) {
            return 0;
        }
        pText = MEditor.getTextClean(pText);
        JEditorPane editor = new JEditorPane("text/html", "");
        MEditor.editorCSS(editor);
        int maxWidth = 0;
        for (String line : lines = pText.split("<br>|<p>")) {
            line = line.replaceAll(CCon.LINE_SEP + " *|</p>", "");
            editor.setText(line);
            int curWidth = editor.getPreferredSize().width;
            if (curWidth <= maxWidth) continue;
            maxWidth = curWidth;
        }
        return maxWidth;
    }

    @NotNull
    public static String getTextClean(@NotNull String pText) {
        return pText.substring(pText.indexOf("<body>") + "<body>".length(), pText.lastIndexOf("</body>")).replaceAll(CCon.LINE_SEP + " *|</p>", "");
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MEditor retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MEditor)MReflection.retrieveComp(pView, pPath, MEditor.class);
    }
}

