/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.filter.types.MFilterField;
import de.maggicraft.mgui.listener.IAction;
import de.maggicraft.mgui.listener.IListenable;
import de.maggicraft.mgui.listener.IListener;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.listener.MListener;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class MField
extends JTextField
implements IComp,
ITippable,
IListenable<DocumentListener, String, DocumentEvent> {
    public static final int EXT_WIDTH = 50;
    public static final int EXT_HEIGHT = 8;
    @NotNull
    private final MMPos mPos;
    private List<IListener<DocumentListener, String, DocumentEvent>> mListeners = new LinkedList<IListener<DocumentListener, String, DocumentEvent>>();
    private MTip mTip;
    private String mLangKey;
    private String mPrevText;
    private String mPlaceholder;
    private boolean mClearWithFocus;
    private boolean mHasFilter;

    public MField(@NotNull MMPos pPos) {
        MCon.styleField(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 27) {
                    MField.this.setText(MField.this.mPrevText.equals(MField.this.mPlaceholder) ? "" : MField.this.mPrevText);
                    MField.this.getParent().requestFocus();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent pEvent) {
                if (!MField.this.mHasFilter) {
                    MField.this.mPrevText = MField.this.getText();
                    if (MField.this.mClearWithFocus || MField.this.getText().equals(MField.this.mPlaceholder)) {
                        MField.this.setText("");
                        MField.this.setForeground(MCon.colorFieldText());
                        MField.this.setFont(MCon.fontField());
                    }
                    MField.this.setBackground(MCon.colorFieldBackgroundFocus());
                    MField.this.setBorder(MCon.borderFieldFocus());
                }
            }

            @Override
            public void focusLost(FocusEvent pEvent) {
                if (!MField.this.mHasFilter) {
                    if (MField.this.getText().isEmpty()) {
                        MField.this.setText(MField.this.mPlaceholder);
                        MField.this.setForeground(MCon.colorFieldTextPlaceholder());
                        MField.this.setFont(MCon.fontFieldPlaceholder());
                    }
                    MField.this.setBackground(MCon.colorFieldBackground());
                    MField.this.setBorder(MCon.borderField());
                }
            }
        });
        this.updateColor();
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public static MField retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MField)MReflection.retrieveComp(pView, pPath, MField.class);
    }

    @NotNull
    public MField clearWithFocus() {
        this.mClearWithFocus = true;
        return this;
    }

    @NotNull
    public MField addListener(IAction<DocumentEvent> pAction) {
        return this.addListener((IListener)new MListener(pAction));
    }

    public MField addListener(IAction<DocumentEvent> pAction, boolean pFireOnce) {
        return this.addListener((IListener)new MListener(pAction, pFireOnce));
    }

    public MField addListener(final IListener<DocumentListener, String, DocumentEvent> pListener) {
        this.mListeners.add(pListener);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent pEvent) {
                pListener.action(MField.this.getText(), pEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent pEvent) {
                pListener.action(MField.this.getText(), pEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent pEvent) {
                pListener.action(MField.this.getText(), pEvent);
            }
        };
        pListener.setParentListener(docListener);
        this.getDocument().addDocumentListener(docListener);
        return this;
    }

    @Override
    public void valueVoid(String pValue) {
        this.setText(pValue);
    }

    @Override
    public void removeParentListener(IListener<DocumentListener, String, DocumentEvent> pListener) {
        this.getDocument().removeDocumentListener(pListener.getParentListener());
    }

    @Override
    public List<IListener<DocumentListener, String, DocumentEvent>> getListeners() {
        return this.mListeners;
    }

    @NotNull
    public MField filter(@NotNull MFilter pFilter) {
        new MFilterField(this, pFilter);
        return this;
    }

    public int getInt() {
        return Integer.parseInt(this.getText());
    }

    public float getFloat() {
        return Float.parseFloat(this.getText());
    }

    public long getLong() {
        return Long.parseLong(this.getText());
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorFieldTextPlaceholder());
        this.setBackground(MCon.colorFieldBackground());
    }

    @Override
    public void updateLang() {
        this.setText(MLangManager.get("f." + this.mLangKey));
        if (this.mPos.isPrefH()) {
            this.mPos.setPrefWidth(this.prefWidth());
        }
        if (this.mTip != null) {
            this.mTip.updateLang(this, "f.tt." + this.mLangKey);
        }
    }

    @Override
    @NotNull
    public MField title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.mPlaceholder = MLangManager.get("f." + pTitle);
        this.setText(this.mPlaceholder);
        this.setName(pTitle);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MField text(@NotNull String pText) {
        this.mPlaceholder = pText;
        this.setText(this.mPlaceholder);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MField name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MField tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MField title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mLangKey = pTitle;
        this.mTip = pTip;
        pTip.tip(this, "f.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
    }

    @Override
    public int prefWidth() {
        return Util.getMetrics(this.getFont()).stringWidth(this.getText()) + 50;
    }

    @Override
    public int prefHeight() {
        return Util.getMetrics(this.getFont()).getHeight() + 8;
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    public int getPrefHeight() {
        return this.mPos.getPrefHeight();
    }

    public void setHasFilter(boolean pHasFilter) {
        this.mHasFilter = pHasFilter;
    }

    public String getPrevText() {
        return this.mPrevText;
    }

    public void setPrevText(String pPrevText) {
        this.mPrevText = pPrevText;
    }

    public String getPlaceholder() {
        return this.mPlaceholder;
    }

    public void setPlaceholder(String pPlaceholder) {
        this.mPlaceholder = pPlaceholder;
    }

    public boolean isClearWithFocus() {
        return this.mClearWithFocus;
    }

    public void setClearWithFocus(boolean pClearWithFocus) {
        this.mClearWithFocus = pClearWithFocus;
    }
}

