/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mlog.MLog;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MFileChooser
extends JFileChooser {
    private String mLangKey;

    public MFileChooser(@Nullable File pFile) {
        this.setCurrentDirectory(pFile);
    }

    @Override
    public void updateUI() {
        LookAndFeel old = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception pE) {
            old = null;
            MLog.log(pE);
        }
        super.updateUI();
        if (old != null) {
            try {
                UIManager.setLookAndFeel(old);
            }
            catch (UnsupportedLookAndFeelException pE) {
                MLog.log(pE);
            }
        }
    }

    public void updateLang() {
        if (this.mLangKey != null) {
            this.title(this.mLangKey);
        }
    }

    @NotNull
    public MFileChooser title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setDialogTitle(MLangManager.get("ch." + pTitle));
        return this;
    }

    @NotNull
    public MFileChooser text(String pText) {
        this.setDialogTitle(pText);
        return this;
    }
}

