/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MScores;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mgui.view.util.IView;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MGraph
extends JPanel
implements IComp,
ITippable {
    private static final Stroke GRAPH_STROKE = new BasicStroke(2.0f);
    private static final int PADDING = 15;
    private static final int LABEL_PADDING = 25;
    private static final int POINT_DIM = 4;
    private static final int NUMBER_Y_DIVISIONS = 10;
    @NotNull
    private List<MScores> mScores;
    @NotNull
    private final MMPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MGraph(@NotNull MMPos pPos) {
        this(pPos, new LinkedList<MScores>());
    }

    public MGraph(@NotNull MMPos pPos, MScores ... pScores) {
        this(pPos, new LinkedList<MScores>(Arrays.asList(pScores)));
    }

    public MGraph(@NotNull MMPos pPos, @NotNull List<MScores> pScores) {
        this.mScores = pScores;
        this.updateColor();
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    @Override
    protected void paintComponent(Graphics pG) {
        int labelWidth;
        FontMetrics metrics;
        int x0;
        int i;
        Graphics2D g2 = (Graphics2D)pG;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(MCon.colorGraphPadding());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        int xSc = !this.mScores.isEmpty() ? this.mScores.get(0).getScores().size() : 0;
        double xScale = ((double)this.getWidth() - 30.0 - 25.0) / (double)(xSc - 1);
        double yScale = ((double)this.getHeight() - 30.0 - 25.0) / (this.getMaxScore() - this.getMinScore());
        g2.setColor(MCon.colorGraphBackground());
        g2.fillRect(40, 15, this.getWidth() - 30 - 25, this.getHeight() - 30 - 25);
        g2.setColor(MCon.colorAccent());
        g2.drawLine(40, this.getHeight() - 15 - 25, 40, 15);
        g2.drawLine(40, this.getHeight() - 15 - 25, this.getWidth() - 15, this.getHeight() - 15 - 25);
        int size = 0;
        if (!this.mScores.isEmpty()) {
            size = this.mScores.get(0).getScores().size();
            for (i = 1; i < this.mScores.size(); ++i) {
                if (this.mScores.get(i).getScores().size() == size) continue;
                throw new IllegalArgumentException();
            }
        }
        for (i = 0; i < 11; ++i) {
            x0 = 40;
            int x1 = 44;
            int y0 = this.getHeight() - (i * (this.getHeight() - 30 - 25) / 10 + 15 + 25);
            if (size > 0) {
                g2.setColor(MCon.colorGraphGrid());
                g2.drawLine(45, y0, this.getWidth() - 15, y0);
                g2.setColor(MCon.colorGraphText());
                String yLabel = Double.toString((double)((int)((this.getMinScore() + (this.getMaxScore() - this.getMinScore()) * ((double)i * 1.0 / 10.0)) * 100.0)) / 100.0);
                metrics = g2.getFontMetrics();
                labelWidth = metrics.stringWidth(yLabel);
                g2.drawString(yLabel, x0 - labelWidth - 5, y0 + metrics.getHeight() / 2 - 3);
            }
            g2.setColor(MCon.colorGraphGrid());
            g2.drawLine(x0, y0, x1, y0);
        }
        for (i = 0; i < size; ++i) {
            if (size <= 1) continue;
            x0 = i * (this.getWidth() - 30 - 25) / (size - 1) + 15 + 25;
            int y0 = this.getHeight() - 15 - 25;
            int y1 = y0 - 4;
            if (i % ((int)((double)size / 20.0) + 1) == 0) {
                g2.setColor(MCon.colorGraphGrid());
                g2.drawLine(x0, this.getHeight() - 15 - 25 - 1 - 4, x0, 15);
                g2.setColor(MCon.colorGraphText());
                String xLabel = Integer.toString(i);
                metrics = g2.getFontMetrics();
                labelWidth = metrics.stringWidth(xLabel);
                g2.drawString(xLabel, x0 - labelWidth / 2, y0 + metrics.getHeight() + 3);
            }
            g2.setColor(MCon.colorGraphGrid());
            g2.drawLine(x0, y0, x0, y1);
        }
        for (MScores score : this.mScores) {
            ArrayList<Point> graphPoints = new ArrayList<Point>();
            List<Double> scores = score.getScores();
            for (int i2 = 0; i2 < scores.size(); ++i2) {
                int x1 = (int)((double)i2 * xScale + 15.0 + 25.0);
                int y1 = (int)((this.getMaxScore() - scores.get(i2)) * yScale + 15.0);
                graphPoints.add(new Point(x1, y1));
            }
            Stroke oldStroke = g2.getStroke();
            g2.setColor(score.getColorLine());
            g2.setStroke(GRAPH_STROKE);
            for (int i3 = 0; i3 < graphPoints.size() - 1; ++i3) {
                int x1 = ((Point)graphPoints.get((int)i3)).x;
                int y1 = ((Point)graphPoints.get((int)i3)).y;
                int x2 = ((Point)graphPoints.get((int)(i3 + 1))).x;
                int y2 = ((Point)graphPoints.get((int)(i3 + 1))).y;
                g2.drawLine(x1, y1, x2, y2);
            }
            g2.setStroke(oldStroke);
            g2.setColor(score.getColorPoint());
            for (Point graphPoint : graphPoints) {
                int x = graphPoint.x - 2;
                int y = graphPoint.y - 2;
                g2.fillOval(x, y, 4, 4);
            }
        }
    }

    private double getMinScore() {
        double minScore = Double.MAX_VALUE;
        for (MScores score : this.mScores) {
            for (double value : score.getScores()) {
                minScore = Math.min(minScore, value);
            }
        }
        return minScore;
    }

    private double getMaxScore() {
        double maxScore = Double.MIN_VALUE;
        for (MScores score : this.mScores) {
            for (double value : score.getScores()) {
                maxScore = Math.max(maxScore, value);
            }
        }
        return maxScore;
    }

    public void updateScores() {
        this.invalidate();
        this.repaint();
    }

    @NotNull
    public MPanel getLegend(@NotNull MMPos pPos) {
        int widLine = 20;
        MPanel panel = new MPanel(pPos){

            @Override
            public int prefWidth() {
                int wid = MCon.defaultGap() * 3 + 20;
                String[] texts = new String[MGraph.this.mScores.size()];
                for (int i = 0; i < texts.length; ++i) {
                    texts[i] = ((MScores)MGraph.this.mScores.get(i)).getName();
                }
                return wid += Util.getWidth(texts);
            }

            @Override
            public int prefHeight() {
                return MCon.defaultGap() + (this.getFontMetrics(MCon.fontText()).getHeight() + MCon.defaultGap()) * MGraph.this.mScores.size();
            }
        };
        int gap = 20 + MCon.defaultGap() * 2;
        MText last = null;
        for (MScores score : this.mScores) {
            MPos pos = last == null ? MPos.pos(panel, "[[<" + gap + ">p,[[p") : MPos.pos("V[[<" + gap + ">p,[]p", last);
            last = new MText(pos).text(score.getName());
            MPanel line = new MPanel(MPos.pos("V[[20,||4", last));
            line.setBackground(score.getColorLine());
        }
        return panel;
    }

    public void setScores(@NotNull List<MScores> pScores) {
        this.mScores = pScores;
        this.updateScores();
    }

    @Override
    public void updateColor() {
        this.setBackground(MCon.colorGraphPadding());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.title(this.mLangKey);
        }
        if (this.mTip != null) {
            this.mTip.updateLang(this, "g.tt." + this.mLangKey);
        }
    }

    @Override
    @NotNull
    public MGraph title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.text(MLangManager.get("g." + pTitle));
        this.setName(pTitle);
        return this;
    }

    @Override
    @NotNull
    public MGraph text(@NotNull String pText) {
        return this;
    }

    @Override
    @NotNull
    public MGraph name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MGraph tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MGraph title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this, "bu.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public int prefWidth() {
        return 0;
    }

    @Override
    public int prefHeight() {
        return 0;
    }

    @NotNull
    public static MGraph retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MGraph)MReflection.retrieveComp(pView, pPath, MGraph.class);
    }
}

