/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MTable;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class MHeader
extends JTableHeader
implements IComp {
    private String[] mHeader;
    private MTable mTable;
    @NotNull
    private final MMPos mPos;
    private String mLangKey;

    public MHeader(@NotNull MMPos pPos) {
        this.setReorderingAllowed(false);
        this.setResizingAllowed(false);
        this.setFont(MCon.fontTableHeader());
        this.updateColor();
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    public void setHeader(String[] pHeader) {
        this.mHeader = pHeader;
    }

    public String[] getHeader() {
        return this.mHeader;
    }

    @Override
    public void updateColor() {
        this.setBackground(MCon.colorTableBackgroundHeader());
        if (this.mHeader != null) {
            TableColumnModel columnModel = this.getColumnModel();
            for (int col = 0; col < this.mHeader.length; ++col) {
                ((JLabel)columnModel.getColumn(col).getHeaderValue()).setForeground(MCon.colorTableTextHeader());
            }
        }
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.title(this.mLangKey);
        }
    }

    @Override
    @NotNull
    public MHeader title(@NotNull String pTitle) {
        return this.title(pTitle, this.mHeader.length);
    }

    @NotNull
    public MHeader title(@NotNull String pTitle, int pCols) {
        this.mLangKey = pTitle;
        this.setName(this.mLangKey);
        String[] header = new String[pCols];
        for (int col = 0; col < pCols; ++col) {
            header[col] = MLangManager.get("ta." + pTitle + MTable.getLetter(col) + 0);
        }
        this.mTable.text(this.mTable.getContent(), header);
        return this;
    }

    @Override
    @NotNull
    public MHeader text(@NotNull String pText) {
        return this.text(pText);
    }

    @NotNull
    public MHeader text(String ... pText) {
        this.mTable.text(this.mTable.getContent(), pText);
        return this;
    }

    public void setLangKey(String pLangKey) {
        this.mLangKey = pLangKey;
    }

    public void langUpdate() {
        DefaultTableCellRenderer rendererHeader = new DefaultTableCellRenderer(){

            @Override
            @NotNull
            public Component getTableCellRendererComponent(JTable pTable, @NotNull Object pValue, boolean pIsSelected, boolean pHasFocus, int pRow, int pColumn) {
                return (Component)pValue;
            }
        };
        for (int i = 0; i < this.mHeader.length; ++i) {
            JLabel label = new JLabel(this.mHeader[i]);
            label.setBorder(new EmptyBorder(5, 10, 5, 10));
            label.setFont(MCon.fontTableHeader());
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setHeaderRenderer(rendererHeader);
            column.setHeaderValue(label);
        }
        this.updateColor();
    }

    @NotNull
    public MHeader enableReordering() {
        this.setReorderingAllowed(true);
        return this;
    }

    @NotNull
    public MHeader enableResizing() {
        this.setResizingAllowed(true);
        return this;
    }

    @Override
    public void setTable(JTable pTable) {
        super.setTable(pTable);
        if (pTable instanceof MTable) {
            this.mTable = (MTable)pTable;
        }
    }

    @Override
    @NotNull
    public MHeader name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    public int prefWidth() {
        int width = 0;
        for (int col = 0; col < this.getColumnModel().getColumnCount(); ++col) {
            width += this.getColumnModel().getColumn(col).getPreferredWidth();
        }
        return width;
    }

    @Override
    public int prefHeight() {
        return Util.getMetrics(this.getFont()).getHeight();
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MHeader retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MHeader)MReflection.retrieveComp(pView, pPath, MHeader.class);
    }
}

