/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class MLabel
extends JLabel
implements IComp,
ITippable {
    @NotNull
    private final MMPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MLabel(@NotNull MMPos pPos) {
        MCon.styleLabel(this);
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public MLabel rep(@NotNull String pTitle, Object ... pReplace) {
        this.mLangKey = pTitle;
        this.setName(pTitle);
        this.text(MLangManager.rep("la." + pTitle, pReplace));
        return this;
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorText());
        this.setBackground(MCon.colorTextBackground());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.setText(MLangManager.get("la." + this.mLangKey));
            if (this.mPos.isPrefH()) {
                this.mPos.setPrefWidth(this.prefWidth());
            }
            if (this.mTip != null) {
                this.mTip.updateLang(this, "la.tt." + this.mLangKey);
            }
        }
    }

    @Override
    @NotNull
    public MLabel title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setText(MLangManager.get("la." + pTitle));
        this.setName(pTitle);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MLabel text(@NotNull String pText) {
        this.setText(pText);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MLabel name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MLabel tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MLabel title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this, "la.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public int prefWidth() {
        return MLabel.getPrefWidth(this.getText(), this.getFont());
    }

    public static int getPrefWidth(@NotNull String pText, Font pFont) {
        String[] lines;
        if (pText.isEmpty()) {
            return 0;
        }
        pText = MLabel.getTextClean(pText);
        JLabel label = new JLabel("");
        label.setFont(pFont);
        int maxWidth = 0;
        for (String line : lines = pText.split("<br>|<p>")) {
            line = line.replaceAll(CCon.LINE_SEP + " *|</p>", "").replace("&bull;", "-");
            label.setText(line);
            int curWidth = label.getPreferredSize().width;
            if (curWidth <= maxWidth) continue;
            maxWidth = curWidth;
        }
        return maxWidth;
    }

    @NotNull
    public static String getTextClean(@NotNull String pText) {
        if (pText.startsWith("<html>") && pText.endsWith("</html>")) {
            pText = pText.substring(6, pText.length() - 7);
        }
        return pText.replaceAll(CCon.LINE_SEP + " *|</p>", "");
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MLabel retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MLabel)MReflection.retrieveComp(pView, pPath, MLabel.class);
    }
}

