/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MPictureMode;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.view.util.IView;
import de.maggicraft.mlog.MLog;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MPicture
extends JLabel
implements IComp,
ITippable {
    private final Object mNotify = new Object();
    private final AtomicBoolean mRunning = new AtomicBoolean(false);
    private ImageIcon mIconSource;
    private MPictureMode mMode;
    private int mNextWidth;
    private int mNextHeight;
    @NotNull
    private final MPicPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MPicture(@NotNull MPicPos pPos, @Nullable ImageIcon pIconSource) {
        this(pPos, pIconSource, MPictureMode.RESIZE_PROP);
    }

    public MPicture(@NotNull MPicPos pPos, @Nullable ImageIcon pIconSource, @NotNull MPictureMode pMode) {
        super(pIconSource, 2);
        this.mMode = pMode;
        this.setOpaque(false);
        this.setBackground(MCon.colorAccent());
        this.setHorizontalTextPosition(0);
        pPos.addComp(this);
        this.mPos = pPos;
        this.setIconSource(pIconSource);
        if (pMode != MPictureMode.CUT) {
            this.consume();
        }
        MCompListeners.compInitialized(this);
    }

    private void consume() {
        if (this.mMode == MPictureMode.CUT) {
            return;
        }
        if (this.mRunning.getAndSet(true)) {
            return;
        }
        new Thread(() -> {
            boolean wait = true;
            while (this.mMode != MPictureMode.CUT) {
                if (wait) {
                    Object object = this.mNotify;
                    synchronized (object) {
                        try {
                            this.mNotify.wait();
                        }
                        catch (InterruptedException pE) {
                            MLog.log(pE);
                        }
                    }
                }
                wait = this.resize();
            }
            this.mRunning.set(false);
        }).start();
    }

    private boolean resize() {
        this.setIcon(new ImageIcon(this.mIconSource.getImage().getScaledInstance(this.mNextWidth, this.mNextHeight, 4)));
        MPos.getFrame(this).repaint();
        return this.getIcon().getIconWidth() == this.mNextWidth && this.getIcon().getIconHeight() == this.mNextHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryResize(int pWidth, int pHeight) {
        if (pWidth == this.mNextWidth && pHeight == this.mNextHeight) {
            return;
        }
        this.mNextWidth = pWidth;
        this.mNextHeight = pHeight;
        Object object = this.mNotify;
        synchronized (object) {
            this.mNotify.notifyAll();
        }
    }

    public void setMode(MPictureMode pMode) {
        if (this.mMode == pMode) {
            return;
        }
        boolean startConsumer = this.mMode == MPictureMode.CUT;
        this.mMode = pMode;
        if (startConsumer) {
            this.consume();
        }
        this.mPos.updateView();
    }

    public void setIconSource(ImageIcon pIcon) {
        this.mIconSource = pIcon;
        this.updatePref();
        this.consume();
        this.mPos.updateView();
    }

    @NotNull
    public MPicture horizontal(int pAlignment) {
        if (pAlignment != 2 && pAlignment != 0 && pAlignment != 4) {
            throw new IllegalArgumentException("horizontal alignment illegal argument: " + pAlignment);
        }
        this.setHorizontalAlignment(pAlignment);
        return this;
    }

    @NotNull
    public MPicture vertical(int pAlignment) {
        if (pAlignment != 1 && pAlignment != 0 && pAlignment != 3) {
            throw new IllegalArgumentException("vertical alignment illegal argument: " + pAlignment);
        }
        this.setVerticalAlignment(pAlignment);
        return this;
    }

    @Override
    public void updateColor() {
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.setText(MLangManager.get("pi." + this.mLangKey));
            if (this.mTip != null) {
                this.mTip.updateLang(this, "pi.tt." + this.mLangKey);
            }
        }
    }

    @Override
    @NotNull
    public MPicture title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setText(MLangManager.get("pi." + pTitle));
        this.setName(pTitle);
        return this;
    }

    @Override
    @NotNull
    public MPicture text(@NotNull String pText) {
        this.setText(pText);
        return this;
    }

    @Override
    @NotNull
    public MPicture name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    @NotNull
    public MPicture tip(@NotNull MTip pTip) {
        pTip.tip(this);
        return this;
    }

    @NotNull
    public MPicture tip(String pTitle, @NotNull MTip pTip) {
        this.mTip = pTip;
        this.mLangKey = pTitle;
        pTip.tip(this, "pi.tt." + pTitle);
        return this;
    }

    @Override
    @NotNull
    public MPicture title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this, "pi.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    public int prefWidth() {
        if (this.mIconSource != null) {
            return this.mIconSource.getIconWidth();
        }
        return 0;
    }

    @Override
    public int prefHeight() {
        if (this.mIconSource != null) {
            return this.mIconSource.getIconHeight();
        }
        return 0;
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    public int getPrefHeight() {
        return this.mPos.getPrefHeight();
    }

    @Override
    public MPicPos getPos() {
        return this.mPos;
    }

    public MPictureMode getMode() {
        return this.mMode;
    }

    public ImageIcon getIconSource() {
        return this.mIconSource;
    }

    @NotNull
    public static MPicture retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MPicture)MReflection.retrieveComp(pView, pPath, MPicture.class);
    }
}

