/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class MProgress
extends JProgressBar
implements IComp,
ITippable {
    public static final int EXT_HEIGHT = 10;
    @NotNull
    private final MMPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MProgress(@NotNull MMPos pPos, int pMin, int pMax) {
        this(pPos);
        this.setMinimum(pMin);
        this.setMaximum(pMax);
        MCompListeners.compInitialized(this);
    }

    public MProgress(@NotNull MMPos pPos) {
        this.mPos = pPos;
        this.mPos.addComp(this);
        MCon.styleProgress(this);
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public MProgress indeterminate() {
        this.setIndeterminate(true);
        return this;
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorProgressForeground());
        this.setBackground(MCon.colorProgressBackground());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null && this.mTip != null) {
            this.mTip.updateLang(this, "pr.tt." + this.mLangKey);
        }
    }

    @Override
    @NotNull
    public MProgress title(@NotNull String pTitle) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MProgress text(@NotNull String pText) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MProgress name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MProgress tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MProgress title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mLangKey = pTitle;
        this.mTip = pTip;
        pTip.tip(this, "pr.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public int prefHeight() {
        return Util.getMetrics(this.getFont()).getHeight() + 10;
    }

    public int getPrefHeight() {
        return this.mPos.getPrefHeight();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MProgress retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MProgress)MReflection.retrieveComp(pView, pPath, MProgress.class);
    }
}

