/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.IAction;
import de.maggicraft.mgui.listener.IListenable;
import de.maggicraft.mgui.listener.IListener;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.listener.MListener;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class MRadio
extends JRadioButton
implements IComp,
ITippable,
IListenable<ItemListener, Boolean, ItemEvent> {
    public static final int EXT_WIDTH = 30;
    public static final int EXT_HEIGHT = 2;
    private List<IListener<ItemListener, Boolean, ItemEvent>> mListeners = new LinkedList<IListener<ItemListener, Boolean, ItemEvent>>();
    @NotNull
    private final MMPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MRadio(@NotNull MMPos pPos, @NotNull ButtonGroup pGroup) {
        this.mPos = pPos;
        this.mPos.addComp(this);
        pGroup.add(this);
        this.setSelected();
        this.updateColor();
        MCon.styleRadio(this);
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public static MRadio[] createRadios(MMPos ... pPos) {
        return MRadio.createRadios(new ButtonGroup(), pPos);
    }

    @NotNull
    public static MRadio[] createRadios(@NotNull ButtonGroup pGroup, MMPos ... pPos) {
        MRadio[] radios = new MRadio[pPos.length];
        for (int i = 0; i < radios.length; ++i) {
            radios[i] = new MRadio(pPos[i], pGroup);
        }
        return radios;
    }

    @NotNull
    public static MRadio retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MRadio)MReflection.retrieveComp(pView, pPath, MRadio.class);
    }

    protected void setSelected() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent pEvent) {
                if (MRadio.this.isSelected()) {
                    MRadio.this.setPressedIcon(MCon.iconRadioPressed());
                } else {
                    MRadio.this.setPressedIcon(MCon.iconRadioPressedOff());
                }
            }
        });
    }

    @NotNull
    public MRadio select() {
        this.setSelected(true);
        return this;
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorRadioForeground());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.title(this.mLangKey);
            if (this.mTip != null) {
                this.mTip.updateLang(this, "ra.tt." + this.mLangKey);
            }
        }
    }

    @Override
    @NotNull
    public MRadio title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setText(MLangManager.get("ra." + pTitle));
        this.setName(pTitle);
        this.updatePref();
        return this;
    }

    @Override
    @NotNull
    public MRadio text(String pText) {
        this.setText(pText);
        this.updatePref();
        return this;
    }

    @Override
    @NotNull
    public MRadio name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MRadio tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MRadio title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mLangKey = pTitle;
        this.mTip = pTip;
        pTip.tip(this, "ra.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
    }

    @Override
    public int prefWidth() {
        int width = 0;
        if (this.getIcon() != null) {
            width = this.getIcon().getIconWidth();
        }
        if (!this.getText().isEmpty()) {
            width = Math.max(Util.getMetrics(this.getFont()).stringWidth(this.getText()) + 30, width);
        }
        return width;
    }

    @Override
    public int prefHeight() {
        int height = 0;
        if (this.getIcon() != null) {
            height = this.getIcon().getIconHeight();
        }
        if (!this.getText().isEmpty()) {
            height = Math.max(Util.getMetrics(this.getFont()).getHeight() + 2, height);
        }
        return height;
    }

    @Override
    public void setIcon(Icon pIcon) {
        super.setIcon(pIcon);
        this.updatePref();
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    public int getPrefHeight() {
        return this.mPos.getPrefHeight();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    public MRadio addListener(IAction<ItemEvent> pAction) {
        return this.addListener((IListener)new MListener(pAction));
    }

    public MRadio addListener(IAction<ItemEvent> pAction, boolean pFireOnce) {
        return this.addListener((IListener)new MListener(pAction, pFireOnce));
    }

    public MRadio addListener(IListener<ItemListener, Boolean, ItemEvent> pListener) {
        this.mListeners.add(pListener);
        ItemListener itemListener = pEvent -> {
            if (pEvent.getStateChange() == 1 || pEvent.getStateChange() == 2) {
                pListener.action(this.isSelected(), pEvent);
            }
        };
        pListener.setParentListener(itemListener);
        this.addItemListener(itemListener);
        return this;
    }

    @Override
    public void valueVoid(Boolean pValue) {
        this.setSelected(pValue);
    }

    @Override
    public void removeParentListener(IListener<ItemListener, Boolean, ItemEvent> pListener) {
        this.removeItemListener(pListener.getParentListener());
    }

    @Override
    public List<IListener<ItemListener, Boolean, ItemEvent>> getListeners() {
        return this.mListeners;
    }
}

