/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mgui.schemes.MCon;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MScores {
    @NotNull
    private final List<Double> mScores;
    private Color mColorLine = MCon.colorAccent();
    private Color mColorPoint = MCon.colorAccent().darker();
    private String mName;
    private final int mMaxSize;

    public MScores(int pMaxSize) {
        this(new LinkedList<Double>(), pMaxSize);
    }

    public MScores(@NotNull List<Double> pScores) {
        this(pScores, Integer.MAX_VALUE);
    }

    public MScores(@NotNull List<Double> pScores, int pMaxSize) {
        this.mScores = pScores;
        this.mMaxSize = pMaxSize;
        while (this.mScores.size() > pMaxSize) {
            this.mScores.remove(0);
        }
    }

    public void add(double pValue) {
        this.mScores.add(pValue);
    }

    public void addMod(double pValue) {
        if (this.mScores.size() >= this.mMaxSize) {
            this.mScores.remove(0);
        }
        this.mScores.add(pValue);
    }

    @NotNull
    public MScores text(String pText) {
        this.mName = pText;
        return this;
    }

    public void setColorLine(Color pColorLine) {
        this.mColorLine = pColorLine;
    }

    public void setColorPoint(Color pColorPoint) {
        this.mColorPoint = pColorPoint;
    }

    @NotNull
    public List<Double> getScores() {
        return this.mScores;
    }

    public Color getColorLine() {
        return this.mColorLine;
    }

    public Color getColorPoint() {
        return this.mColorPoint;
    }

    @NotNull
    public String getName() {
        return this.mName == null ? "" : this.mName;
    }
}

