/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.IAction;
import de.maggicraft.mgui.listener.IListenable;
import de.maggicraft.mgui.listener.IListener;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.listener.MListener;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class MSlider
extends JSlider
implements IComp,
ITippable,
IListenable<ChangeListener, Integer, ChangeEvent> {
    @NotNull
    private final MMPos mPos;
    private List<IListener<ChangeListener, Integer, ChangeEvent>> mListeners = new LinkedList<IListener<ChangeListener, Integer, ChangeEvent>>();
    private MTip mTip;
    private String mLangKey;

    public MSlider(@NotNull MMPos pPos) {
        this.updateColor();
        MCon.styleSlider(this);
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    public MSlider(@NotNull MMPos pPos, int pMin, int pMax) {
        this(pPos);
        if (pMin > pMax) {
            throw new IllegalArgumentException("min (" + pMin + ") > max (" + pMax + ')');
        }
        this.setMinimum(pMin);
        this.setMaximum(pMax);
        MCompListeners.compInitialized(this);
    }

    public MSlider(@NotNull MMPos pPos, int pMin, int pMax, int pStart) {
        this(pPos, pMin, pMax);
        this.setValue(pStart);
        MCompListeners.compInitialized(this);
    }

    public MSlider(@NotNull MMPos pPos, int pMin, int pMax, int pStart, int pOrientation) {
        this(pPos, pMin, pMax, pStart);
        if (pOrientation != 1 && pOrientation != 0) {
            throw new IllegalArgumentException("illegal orientation: " + pOrientation);
        }
        this.setOrientation(pOrientation);
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public MSlider addTicks() {
        return this.addTicks(5, 25);
    }

    @NotNull
    public MSlider addTicks(int pMinor, int pMajor) {
        this.setMinorTickSpacing(pMinor);
        this.setMajorTickSpacing(pMajor);
        return this;
    }

    @NotNull
    public MSlider addLabels(int ... pPos) {
        JLabel[] labels = new JLabel[pPos.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = new JLabel(Integer.toString(pPos[i]));
        }
        return this.addLabels(pPos, labels);
    }

    @NotNull
    public MSlider addLabels(@NotNull int[] pPos, @NotNull String[] pTexts) {
        if (pPos.length != pTexts.length) {
            throw new IllegalArgumentException("not the same length");
        }
        JLabel[] labels = new JLabel[pTexts.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = new JLabel(pTexts[i]);
        }
        return this.addLabels(pPos, labels);
    }

    @NotNull
    public MSlider addLabels(@NotNull int[] pPos, @NotNull JLabel[] pLabels) {
        if (pPos.length != pLabels.length) {
            throw new IllegalArgumentException("");
        }
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < pPos.length; ++i) {
            table.put(pPos[i], pLabels[i]);
            pLabels[i].setForeground(Color.WHITE);
        }
        this.setLabelTable(table);
        this.setPaintLabels(true);
        return this;
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorText());
        Dictionary dictionary = this.getLabelTable();
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                JLabel label = (JLabel)dictionary.get(keys.nextElement());
                label.setForeground(this.getForeground());
            }
        }
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null && this.mTip != null) {
            this.mTip.updateLang(this, "sl.tt." + this.mLangKey);
        }
    }

    @Override
    @NotNull
    public MSlider title(@NotNull String pTitle) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MSlider text(@NotNull String pText) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MSlider name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MSlider tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MSlider title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mLangKey = pTitle;
        this.mTip = pTip;
        this.setName(pTitle);
        pTip.tip(this, "sl.tt." + pTitle);
        return this;
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public int prefWidth() {
        return 20;
    }

    @Override
    public int prefHeight() {
        return 20;
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MSlider retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MSlider)MReflection.retrieveComp(pView, pPath, MSlider.class);
    }

    public MSlider addListener(IAction<ChangeEvent> pAction) {
        return this.addListener((IListener)new MListener(pAction));
    }

    public MSlider addListener(IAction<ChangeEvent> pAction, boolean pFireOnce) {
        return this.addListener((IListener)new MListener(pAction, pFireOnce));
    }

    public MSlider addListener(IListener<ChangeListener, Integer, ChangeEvent> pListener) {
        this.mListeners.add(pListener);
        ChangeListener changeListener = pEvent -> {
            if (!this.getValueIsAdjusting()) {
                pListener.action(this.getValue(), pEvent);
            }
        };
        pListener.setParentListener(changeListener);
        this.addChangeListener(changeListener);
        return this;
    }

    @Override
    public void valueVoid(Integer pValue) {
        this.setValue(pValue);
    }

    @Override
    public void removeParentListener(IListener<ChangeListener, Integer, ChangeEvent> pListener) {
        this.removeChangeListener(pListener.getParentListener());
    }

    @Override
    public List<IListener<ChangeListener, Integer, ChangeEvent>> getListeners() {
        return this.mListeners;
    }
}

