/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;

public class MSpinner
extends JSpinner
implements IComp,
ITippable {
    @NotNull
    private final MMPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MSpinner(@NotNull MMPos pPos) {
        this.updateColor();
        MCon.styleSpinner(this);
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    public MSpinner(@NotNull MMPos pPos, @NotNull SpinnerModel pModel) {
        this(pPos);
        this.setModel(pModel);
        MCompListeners.compInitialized(this);
    }

    public static SpinnerNumberModel modelInt(int pStart, int pMin, int pMax, int pStep) {
        return new SpinnerNumberModel(pStart, pMin, pMax, pStep);
    }

    public static SpinnerNumberModel modelDouble(double pStart, double pMin, double pMax, double pStep) {
        return new SpinnerNumberModel(pStart, pMin, pMax, pStep);
    }

    public static SpinnerListModel modelList(@NotNull List<?> pList) {
        return new SpinnerListModel(pList);
    }

    public static SpinnerListModel modelArray(@NotNull Object[] pObjects) {
        return new SpinnerListModel(pObjects);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorText());
        this.setBackground(MCon.colorTextBackground());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null && this.mTip != null) {
            this.mTip.updateLang(this, "sl.tt." + this.mLangKey);
        }
    }

    @Override
    @NotNull
    public MSpinner title(@NotNull String pTitle) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MSpinner text(@NotNull String pText) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MSpinner name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MSpinner tip(@NotNull MTip pTip) {
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MSpinner title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mLangKey = pTitle;
        this.mTip = pTip;
        pTip.tip(this, "sp.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public int prefWidth() {
        return 0;
    }

    @Override
    public int prefHeight() {
        return 0;
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MSpinner retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MSpinner)MReflection.retrieveComp(pView, pPath, MSpinner.class);
    }
}

