/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.IAction;
import de.maggicraft.mgui.listener.IListenable;
import de.maggicraft.mgui.listener.IListener;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.listener.MListener;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public class MSwitcher
extends JCheckBox
implements IComp,
ITippable,
IListenable<ItemListener, Boolean, ItemEvent> {
    public static final int EXT_WIDTH = 50;
    public static final int EXT_HEIGHT = 2;
    private List<IListener<ItemListener, Boolean, ItemEvent>> mListeners = new LinkedList<IListener<ItemListener, Boolean, ItemEvent>>();
    @NotNull
    private final MMPos mPos;
    private MTip mTipActivated;
    private MTip mTipDeactivated;
    private String mLangKey;

    public MSwitcher(@NotNull MMPos pPos) {
        this(pPos, false);
    }

    public MSwitcher(@NotNull MMPos pPos, boolean pSelected) {
        this.setSelected(pSelected);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent pEvent) {
                MSwitcher.this.setBorderPainted(false);
            }

            @Override
            public void focusGained(FocusEvent pEvent) {
                if (!MSwitcher.this.getModel().isRollover()) {
                    MSwitcher.this.setBorderPainted(true);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 10) {
                    MSwitcher.this.doClick();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent pEvent) {
                MSwitcher.this.setPressedIcon(MSwitcher.this.isSelected() ? MCon.iconSwitcherPressed() : MCon.iconSwitcherPressedOff());
            }
        });
        this.addItemListener(pEvent -> {
            Action toolTipAction = this.getActionMap().get("postTip");
            if (toolTipAction != null) {
                ActionEvent postTip = new ActionEvent(this, 1001, "");
                toolTipAction.actionPerformed(postTip);
            }
        });
        this.updateColor();
        MCon.styleSwitcher(this);
        pPos.addComp(this);
        this.mPos = pPos;
        this.updatePref();
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public static MSwitcher retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MSwitcher)MReflection.retrieveComp(pView, pPath, MSwitcher.class);
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorSwitcherForeground());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.title(this.mLangKey);
            if (this.mTipActivated != null) {
                if (this.mTipDeactivated != null) {
                    this.mTipActivated.updateLang(this, "sw.ac." + this.mLangKey);
                    this.mTipDeactivated.updateLang(this, "sw.de." + this.mLangKey);
                } else {
                    this.mTipActivated.updateLang(this, "sw.tt." + this.mLangKey);
                }
            }
        }
    }

    @Override
    @NotNull
    public MSwitcher text(@NotNull String pText) {
        this.setText(pText);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MSwitcher name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MSwitcher title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setText(MLangManager.get("sw." + pTitle));
        this.setName(pTitle);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MSwitcher tip(@NotNull MTip pTip) {
        this.mTipActivated = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MSwitcher title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mLangKey = pTitle;
        this.mTipActivated = pTip;
        pTip.tip(this, "sw.tt." + pTitle);
        return this.title(pTitle);
    }

    @NotNull
    public MSwitcher tips() {
        return this.tips(this.mLangKey, new MTip(), new MTip());
    }

    @NotNull
    public MSwitcher tips(String pTitle, @NotNull MTip pTipActivated, @NotNull MTip pTipDeactivated) {
        this.mLangKey = pTitle;
        this.mTipActivated = pTipActivated;
        this.mTipDeactivated = pTipDeactivated;
        if (this.isSelected()) {
            this.mTipActivated.tip(this, "sw.ac." + this.mLangKey);
            this.mTipDeactivated.setText(MLangManager.get("sw.de." + this.mLangKey));
        } else {
            this.mTipDeactivated.tip(this, "sw.de." + this.mLangKey);
            this.mTipActivated.setText(MLangManager.get("sw.ac." + this.mLangKey));
        }
        this.addItemListener(pEvent -> (this.isSelected() ? this.mTipActivated : this.mTipDeactivated).tip(this));
        return this;
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTipDeactivated == null || this.isSelected() ? this.mTipActivated : this.mTipDeactivated;
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
    }

    @Override
    public int prefWidth() {
        return Util.getMetrics(this.getFont()).stringWidth(this.getText()) + 50;
    }

    @Override
    public int prefHeight() {
        return Util.getMetrics(this.getFont()).getHeight() + 2;
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    public int getPrefHeight() {
        return this.mPos.getPrefHeight();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public MSwitcher addAction(@NotNull ItemListener pListener) {
        this.addItemListener(pListener);
        return this;
    }

    public MSwitcher addListener(IAction<ItemEvent> pAction) {
        return this.addListener((IListener)new MListener(pAction));
    }

    public MSwitcher addListener(IAction<ItemEvent> pAction, boolean pFireOnce) {
        return this.addListener((IListener)new MListener(pAction, pFireOnce));
    }

    public MSwitcher addListener(IListener<ItemListener, Boolean, ItemEvent> pListener) {
        this.mListeners.add(pListener);
        ItemListener itemListener = pEvent -> pListener.action(this.isSelected(), pEvent);
        pListener.setParentListener(itemListener);
        this.addItemListener(itemListener);
        return this;
    }

    @Override
    public void valueVoid(Boolean pValue) {
        this.setSelected(pValue);
    }

    @Override
    public void removeParentListener(IListener<ItemListener, Boolean, ItemEvent> pListener) {
        this.removeItemListener(pListener.getParentListener());
    }

    @Override
    public List<IListener<ItemListener, Boolean, ItemEvent>> getListeners() {
        return this.mListeners;
    }
}

