/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.ITableRenderer;
import de.maggicraft.mgui.comp.MHeader;
import de.maggicraft.mgui.comp.MTableUtil;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class MTable
extends JTable
implements IComp {
    public static final int GAP_HORIZONTAL = 10;
    public static final int GAP_VERTICAL = 5;
    private static int sId = 0;
    private Object[][] mContent;
    private float[] mColumnPercent;
    private int[] mRowHeight;
    @NotNull
    private final MHeader mHeader;
    @NotNull
    private final MMPos mPos;
    private String mLangKey;
    private final int mId = ++sId;

    public MTable(@NotNull MMPos pPos, @NotNull MHeader pHeader) {
        this.mHeader = pHeader;
        this.setTableHeader(pHeader);
        MCon.styleTable(this);
        this.updateColor();
        pPos.addComp(this);
        this.mPos = pPos;
        this.updatePref();
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public MTable enableEditing() {
        this.setModel(new DefaultTableModel(this.mContent, this.mHeader.getHeader()));
        return this;
    }

    public Object[][] getContent() {
        return this.mContent;
    }

    @NotNull
    public MHeader getHeader() {
        return this.mHeader;
    }

    public int[] getMRowHeight() {
        return this.mRowHeight;
    }

    @NotNull
    public TableModel createTableModel() {
        return new DefaultTableModel(this.mContent, this.mHeader.getHeader()){

            @Override
            public boolean isCellEditable(int pRow, int pColumn) {
                return false;
            }
        };
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorTableText());
        this.setDefaultRenderer(String.class, new MTableUtil.MStringCellRenderer(this));
        this.setDefaultRenderer(Boolean.class, new MTableUtil.MBooleanCellRenderer());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.title(this.mLangKey);
        }
    }

    @Override
    @NotNull
    public MTable title(@NotNull String pTitle) {
        return this.title(pTitle, pTitle, this.mContent.length, this.mContent[0].length);
    }

    @NotNull
    public MTable title(String pTitle, int pRows, int pCols) {
        return this.title(pTitle, pTitle, pRows, pCols);
    }

    @NotNull
    public MTable title(String pTitleContent, String pTitleHeader, int pRows, int pCols) {
        this.mLangKey = pTitleContent;
        this.setName(this.mLangKey);
        this.mHeader.setLangKey(pTitleHeader);
        String[] header = new String[pCols];
        for (int col = 0; col < pCols; ++col) {
            header[col] = MLangManager.get("ta." + pTitleHeader + MTable.getLetter(col) + 0);
        }
        Object[][] content = new Object[pRows][pCols];
        for (int row = 0; row < content.length; ++row) {
            for (int col = 0; col < content[row].length; ++col) {
                content[row][col] = this.populateContent(pTitleContent, row, col);
            }
        }
        return this.text(content, header);
    }

    public Object populateContent(String pTitle, int pRow, int pCol) {
        return MLangManager.get("ta." + pTitle + MTable.getLetter(pCol) + (pRow + 1));
    }

    public static char getLetter(int pLetter) {
        if (pLetter > 24) {
            throw new IllegalArgumentException("only 24 columns supported");
        }
        return (char)(65 + pLetter);
    }

    @NotNull
    public MTable text(Object[][] pContent, String[] pHeader) {
        this.mHeader.setHeader(pHeader);
        return this.text(pContent);
    }

    @NotNull
    public MTable text(Object[][] pContent) {
        this.mContent = pContent;
        this.mRowHeight = new int[this.mContent.length];
        this.setModel(this.createTableModel());
        this.mHeader.setColumnModel(this.getColumnModel());
        this.updateColor();
        this.updatePref();
        this.updateMinWidth();
        this.mHeader.langUpdate();
        return this;
    }

    @Override
    @NotNull
    public MTable text(@NotNull String pText) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MTable name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
        this.updateMinWidth();
    }

    @Override
    public void updatePref() {
        if (this.mPos == null) {
            return;
        }
        this.mHeader.updatePref();
        boolean changed = false;
        if (this.mPos.isPrefH()) {
            int width = this.prefWidth();
            this.mPos.setPrefWidth(width);
            boolean bl = changed = width != this.mPos.getComp().getWidth();
        }
        if (this.mPos.isPrefV()) {
            int height = this.prefHeight();
            this.mPos.setPrefHeight(height);
            changed |= height != this.mPos.getComp().getHeight();
        }
        if (changed) {
            this.mPos.updateView();
        }
    }

    @Override
    public int prefWidth() {
        TableModel model = this.getModel();
        int width = 0;
        for (int col = 0; col < model.getColumnCount(); ++col) {
            int colWidth = this.prefWidthColumn(col);
            width += colWidth;
            this.getColumnModel().getColumn(col).setPreferredWidth(colWidth);
            this.mHeader.getColumnModel().getColumn(col).setPreferredWidth(colWidth);
        }
        return width;
    }

    public int prefWidthColumn(int pCol) {
        TableCellRenderer cellRenderer = this.getColumnModel().getColumn(pCol).getCellRenderer();
        if (cellRenderer == null) {
            cellRenderer = this.getDefaultRenderer(this.getColumnClass(pCol));
        }
        TableModel model = this.getModel();
        if (cellRenderer instanceof ITableRenderer) {
            ITableRenderer renderer = (ITableRenderer)((Object)cellRenderer);
            int colWidth = Util.getWidth(this.mHeader.getFont(), this.mHeader.getHeader()[pCol]) + 20;
            for (int row = 0; row < model.getRowCount(); ++row) {
                int cur = renderer.width(row, pCol);
                if (cur <= colWidth) continue;
                colWidth = cur;
            }
            return colWidth;
        }
        throw new IllegalArgumentException("wrong cell-renderer for column: " + pCol);
    }

    @NotNull
    public MTable relativeWidth(float ... pPercentages) {
        if (pPercentages.length != this.getColumnCount()) {
            throw new IllegalArgumentException("relative widths should equal the quantity of columns");
        }
        float sum = 0.0f;
        for (float percentage : pPercentages) {
            sum += percentage;
        }
        if (sum == 0.0f) {
            sum = 1.0f;
        }
        for (int i = 0; i < pPercentages.length; ++i) {
            pPercentages[i] = pPercentages[i] / sum;
        }
        boolean createNewListener = this.mColumnPercent == null;
        this.mColumnPercent = pPercentages;
        this.updateMinWidth();
        if (createNewListener) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent pEvent) {
                    MTable.this.resizeColumns(MTable.this.mColumnPercent);
                }
            });
        }
        return this;
    }

    private void resizeColumns(float[] pPercentages) {
        int totalWidth = this.getWidth();
        TableColumnModel model = this.getColumnModel();
        for (int col = 0; col < model.getColumnCount(); ++col) {
            int relWidth = Math.round(pPercentages[col] * (float)totalWidth);
            this.updateMinWidth();
            model.getColumn(col).setPreferredWidth(relWidth);
            model.getColumn(col).setMaxWidth(relWidth);
        }
    }

    public void updateMinWidth() {
        TableModel model = this.getModel();
        for (int col = 0; col < model.getColumnCount(); ++col) {
            this.prefWidthColumn(col);
        }
    }

    @Override
    public int prefHeight() {
        TableModel model = this.getModel();
        int height = 0;
        for (int row = 0; row < model.getRowCount(); ++row) {
            height += this.getRowHeight(row);
        }
        return height;
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MTable retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MTable)MReflection.retrieveComp(pView, pPath, MTable.class);
    }

    public int getId() {
        return this.mId;
    }
}

