/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mgui.comp.ITableRenderer;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MLabel;
import de.maggicraft.mgui.comp.MTable;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

public final class MTableUtil {
    private MTableUtil() {
    }

    private static void calcHeight(@NotNull MTable pTable, int pRow, int pColumn, int pCurHeight) {
        if (pColumn == 0) {
            pTable.getMRowHeight()[pRow] = 20;
        }
        pTable.getMRowHeight()[pRow] = Math.max(pTable.getMRowHeight()[pRow], pCurHeight);
        if (pColumn + 1 == pTable.getColumnCount() && pTable.getRowHeight(pRow) != pTable.getMRowHeight()[pRow]) {
            pTable.setRowHeight(pRow, pTable.getMRowHeight()[pRow]);
            pTable.updatePref();
        }
    }

    public static class MBooleanCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @NotNull
        private final JCheckBox editor = new JCheckBox();

        public MBooleanCellEditor() {
            MCon.styleSwitcher(this.editor);
            this.editor.setOpaque(true);
            this.editor.setVerticalAlignment(1);
            this.editor.setFont(MCon.fontSwitcher());
        }

        @Override
        @NotNull
        public Component getTableCellEditorComponent(JTable pTable, Object pValue, boolean pIsSelected, int pRow, int pColumn) {
            this.editor.setBackground(pRow % 2 == 0 ? MCon.colorTableBackgroundEven() : MCon.colorTableBackgroundOdd());
            if (pValue instanceof Boolean) {
                this.editor.setSelected((Boolean)pValue);
            }
            return this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.isSelected();
        }
    }

    public static class MBooleanCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    ITableRenderer {
        public MBooleanCellRenderer() {
            MCon.styleSwitcher(this);
            this.setOpaque(true);
            this.setVerticalAlignment(1);
            this.setFont(MCon.fontSwitcher());
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(JTable pTable, Object value, boolean isSelected, boolean hasFocus, int pRow, int pColumn) {
            this.setBackground(pRow % 2 == 0 ? MCon.colorTableBackgroundEven() : MCon.colorTableBackgroundOdd());
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            }
            MTableUtil.calcHeight((MTable)pTable, pRow, pColumn, this.height(pRow, pColumn));
            return this;
        }

        @Override
        public int width(int pRow, int pCol) {
            return 50;
        }

        @Override
        public int height(int pRow, int pCol) {
            return Util.getMetrics(this.getFont()).getHeight() + 2;
        }
    }

    public static class MStringCellRenderer
    extends JLabel
    implements TableCellRenderer,
    ITableRenderer {
        private final JTable mTable;

        public MStringCellRenderer(JTable pTable) {
            this.mTable = pTable;
            this.setOpaque(true);
            this.setAlignmentY(1.0f);
            this.setBorder(new EmptyBorder(5, 10, 5, 10));
            this.setForeground(MCon.colorTableText());
            this.setVerticalAlignment(1);
            this.setFont(this.mTable.getFont());
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(JTable pTable, Object pValue, boolean pIsSelected, boolean pHasFocus, int pRow, int pColumn) {
            this.setBackground(pRow % 2 == 0 ? MCon.colorTableBackgroundEven() : MCon.colorTableBackgroundOdd());
            this.setText("<html>" + pValue + "</html>");
            MTableUtil.calcHeight((MTable)pTable, pRow, pColumn, this.height(pRow, pColumn));
            return this;
        }

        @Override
        public int width(int pRow, int pCol) {
            return MLabel.getPrefWidth((String)this.mTable.getValueAt(pRow, pCol), this.mTable.getFont()) + 20;
        }

        @Override
        public int height(int pRow, int pCol) {
            JEditorPane editor = new JEditorPane();
            MCon.styleEditor(editor);
            StyleSheet style = ((HTMLDocument)editor.getDocument()).getStyleSheet();
            StringBuilder rules = new StringBuilder().append("body {").append(MEditor.toCSSColor(MCon.colorEditorPaneForeground())).append(MEditor.toCSSFont(this.mTable.getFont())).append("} a {").append(MEditor.toCSSColor(MCon.colorAccent())).append("font-weight: bold; }");
            style.addRule(rules.toString());
            int width = this.mTable.getColumnModel().getColumn(pCol).getWidth() - 20;
            editor.setBounds(0, 0, width, 10);
            editor.setMaximumSize(new Dimension(width, 1000));
            editor.setText("<html>" + this.mTable.getValueAt(pRow, pCol) + "</html>");
            return editor.getPreferredSize().height + 10;
        }
    }
}

