/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public class MText
extends JTextArea
implements IComp,
ITippable {
    @NotNull
    private final MMPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MText(@NotNull MMPos pPos) {
        MCon.styleText(this);
        this.updateColor();
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public MText rep(@NotNull String pTitle, Object ... pReplace) {
        this.mLangKey = pTitle;
        this.setName(pTitle);
        this.text(MLangManager.rep("te." + pTitle, pReplace));
        return this;
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorText());
        this.setBackground(MCon.colorTextBackground());
        this.setSelectedTextColor(MCon.colorTextSelection());
        this.setSelectionColor(MCon.colorTextSelectionBackground());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.setText(MLangManager.get("te." + this.mLangKey));
            if (this.mPos.isPrefH()) {
                this.mPos.setPrefWidth(this.prefWidth());
            }
            if (this.mTip != null) {
                this.mTip.updateLang(this, "te.tt." + this.mLangKey);
            }
        }
    }

    @Override
    @NotNull
    public MText title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setText(MLangManager.get("te." + pTitle));
        this.setName(pTitle);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MText text(@NotNull String pText) {
        this.setText(pText);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MText name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MText tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MText title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mLangKey = pTitle;
        this.mTip = pTip;
        pTip.tip(this, "te.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
    }

    @Override
    public int prefWidth() {
        String[] parts = this.getText().split(CCon.LINE_SEP);
        return Math.max(Util.getWidth(this.getFont(), parts), 5);
    }

    @Override
    public int prefHeight() {
        return Util.getMetrics(this.getFont()).getHeight();
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MText retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MText)MReflection.retrieveComp(pView, pPath, MText.class);
    }
}

