/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;

public class MTextPane
extends JTextPane
implements IComp,
ITippable {
    @NotNull
    private final MMPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MTextPane(@NotNull MMPos pPos) {
        MCon.styleText(this);
        this.updateColor();
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public MTextPane rep(@NotNull String pTitle, Object ... pReplace) {
        this.mLangKey = pTitle;
        this.setName(pTitle);
        this.text(MLangManager.rep("tp." + pTitle, pReplace));
        return this;
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorText());
        this.setBackground(MCon.colorTextBackground());
        this.setSelectedTextColor(MCon.colorTextSelection());
        this.setSelectionColor(MCon.colorTextSelectionBackground());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.setText(MLangManager.get("tp." + this.mLangKey));
            if (this.mPos.isPrefH()) {
                this.mPos.setPrefWidth(this.prefWidth());
            }
            if (this.mTip != null) {
                this.mTip.updateLang(this, "tp.tt." + this.mLangKey);
            }
        }
    }

    @Override
    @NotNull
    public MTextPane title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setText(MLangManager.get("tp." + pTitle));
        this.setName(pTitle);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MTextPane text(@NotNull String pText) {
        this.setText(pText);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MTextPane name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MTextPane tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MTextPane title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mLangKey = pTitle;
        this.mTip = pTip;
        pTip.tip(this, "tp.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
    }

    @Override
    public int prefWidth() {
        return Util.getMetrics(this.getFont()).stringWidth(this.getText());
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MTextPane retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MTextPane)MReflection.retrieveComp(pView, pPath, MTextPane.class);
    }
}

