/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.ICompound;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MTitle
extends JComponent
implements IComp,
ITippable,
ICompound {
    private static final int GAP_H = 15;
    private static final int GAP_V = 5;
    @NotNull
    private final MPos mPos;
    @NotNull
    private final MText mText;
    @NotNull
    private final JLabel mLabel;
    private String mLangKey;
    private int mTextPrefWidth;
    private int mTextPrefHeight;

    public MTitle(@NotNull MPos pPos) {
        this.mText = new MText(new MMPos(pPos.getView())){

            @Override
            @NotNull
            public MText title(@NotNull String pTitle, @NotNull MTip pTip) {
                MTitle.this.mLangKey = pTitle;
                this.tip(new MTip(MLangManager.get("ti.tt." + pTitle), pTip.getLines()));
                MTitle.this.title(pTitle);
                return this;
            }
        };
        this.mLabel = new JLabel();
        MCon.styleTitle(this);
        if (pPos.isPrefV()) {
            pPos.setPrefHeight(this.prefHeight());
        }
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public static MTitle retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MTitle)MReflection.retrieveComp(pView, pPath, MTitle.class);
    }

    @Override
    public void remove() {
        this.mLabel.getParent().remove(this.mLabel);
    }

    @Override
    @NotNull
    public MTitle addTo(@NotNull Container pContainer) {
        if (pContainer instanceof JLayeredPane) {
            int layer = 0;
            if (this.mPos instanceof LPos) {
                layer = ((LPos)this.mPos).getLayer();
            }
            JLayeredPane layered = (JLayeredPane)pContainer;
            layered.setLayer(this.mLabel, layer);
            layered.add(this.mLabel);
        } else {
            pContainer.add(this);
            pContainer.add(this.mText);
            pContainer.add(this.mLabel);
        }
        return this;
    }

    @Override
    public void setForeground(Color pColor) {
        this.mText.setForeground(pColor);
    }

    @Override
    public void setBackground(Color pColor) {
        this.mLabel.setBackground(pColor);
    }

    @Override
    public Font getFont() {
        return this.mText.getFont();
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.mText.setFont(pFont);
        this.updatePref();
    }

    public String getText() {
        return this.mText.getText();
    }

    @NotNull
    public MText getTextComp() {
        return this.mText;
    }

    @NotNull
    public JLabel getLabel() {
        return this.mLabel;
    }

    @Override
    public void updateColor() {
        this.mText.setForeground(MCon.colorTitleText());
        this.mText.setBackground(MCon.colorTextBackground());
        this.mLabel.setBackground(MCon.colorTitleLine());
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.mText.setText(MLangManager.get("ti." + this.mLangKey));
            int prefWidth = this.prefWidth();
            if (this.mPos.isPrefH()) {
                this.mPos.setPrefWidth(prefWidth);
            }
            if (this.mText.getTip() != null) {
                this.mText.getTip().updateLang(this, "ti.tt." + this.mLangKey);
            }
        }
    }

    @Override
    @NotNull
    public MTitle title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.mText.text(MLangManager.get("ti." + pTitle));
        this.setName(pTitle);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MTitle text(@NotNull String pText) {
        this.mText.text(pText);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MTitle name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public void setOpaque(boolean pOpaque) {
        super.setOpaque(pOpaque);
        this.mText.setOpaque(pOpaque);
        this.mLabel.setOpaque(pOpaque);
    }

    @Override
    public void setVisible(boolean pVisible) {
        super.setVisible(pVisible);
        this.mText.setVisible(pVisible);
        this.mLabel.setVisible(pVisible);
    }

    @Override
    public void setName(String pName) {
        super.setName(pName);
        this.mText.setName(pName);
    }

    @Override
    public String getToolTipText() {
        return this.mText.getToolTipText();
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MTitle tip(@NotNull MTip pTip) {
        this.mText.tip(pTip);
        return this;
    }

    @Override
    @NotNull
    public MTitle title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mText.title(pTitle, pTip);
        return this;
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mText.getTip();
    }

    @NotNull
    public MTitle rep(@NotNull String pTitle, Object ... pReplace) {
        this.mLangKey = pTitle;
        this.setName(pTitle);
        this.text(MLangManager.rep("ti." + pTitle, pReplace));
        return this;
    }

    @Override
    public void setBounds(int pPosX, int pPosY, int pWidth, int pHeight) {
        int textHeight;
        int textWidth = this.mTextPrefWidth;
        if (textWidth > pWidth) {
            textWidth = pWidth;
        } else if (textWidth < this.mPos.getWidthMin()) {
            textWidth = this.mPos.getWidthMin();
        }
        if (this.mPos.is(131072)) {
            textHeight = this.mPos.getHeightMin();
        } else {
            textHeight = this.mPos.is(32768) ? this.mTextPrefHeight : pHeight;
            if (textHeight > pHeight) {
                textHeight = pHeight;
            } else if (textHeight < this.mPos.getHeightMin()) {
                textHeight = this.mPos.getHeightMin();
            }
        }
        boolean labelHeight = true;
        int labelPosY = pPosY + textHeight + 5 - 1;
        if (labelPosY > pPosY + pHeight) {
            labelPosY = pPosY + pHeight - 1;
        }
        this.mText.setBounds(pPosX + 15, pPosY, textWidth, textHeight);
        this.mLabel.setBounds(pPosX, labelPosY, pWidth, 1);
        super.setBounds(pPosX, pPosY, pWidth, pHeight);
    }

    @Override
    public void updatePrefWidth() {
        int width = this.prefWidth();
        this.mPos.setPrefWidth(width);
        if (width != this.mPos.getComp().getWidth()) {
            this.mPos.updateView();
        }
    }

    @Override
    public int prefWidth() {
        this.mTextPrefWidth = Util.getMetrics(this.mText.getFont()).stringWidth(this.mText.getText());
        return this.mTextPrefWidth + 30;
    }

    @Override
    public int prefHeight() {
        this.mTextPrefHeight = Util.getMetrics(this.mText.getFont()).getHeight();
        return this.mTextPrefHeight + 5;
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    public int getPrefHeight() {
        return this.mPos.getPrefHeight();
    }

    @Override
    @Nullable
    public MMPos getPos() {
        return this.mPos;
    }
}

