/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.comp;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.NotNull;

public class MToggle
extends JToggleButton
implements IComp,
ITippable {
    private static final int EXT_WIDTH = 50;
    @NotNull
    private final MMPos mPos;
    private MTip mTip;
    private String mLangKey;
    private Shape mShape;
    protected boolean mIconBased;

    public MToggle(@NotNull MMPos pPos, boolean pSelected) {
        this(pPos, pSelected, false);
        MCon.styleToggleButton(this);
        this.updateColor();
        MCompListeners.compInitialized(this);
    }

    public MToggle(@NotNull MMPos pPos, boolean pSelected, boolean pIconBased) {
        this.mIconBased = pIconBased;
        this.mPos = pPos;
        this.mPos.addComp(this);
        this.setSelected(pSelected);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 10) {
                    MToggle.this.doClick();
                }
            }
        });
        MCompListeners.compInitialized(this);
    }

    public MToggle(@NotNull MMPos pPos, boolean pSelected, Icon pIcon, Icon pIconSelected, Icon pIconRollover, Icon pIconSelectedRollover, Icon pIconPressed) {
        this(pPos, pSelected, true);
        this.setIcon(pIcon);
        this.setSelectedIcon(pIconSelected);
        this.setRolloverIcon(pIconRollover);
        this.setRolloverSelectedIcon(pIconSelectedRollover);
        this.setPressedIcon(pIconPressed);
        MCon.styleToggleButtonIcon(this, pIcon);
        this.updateColor();
        MCompListeners.compInitialized(this);
    }

    public MToggle addAction(@NotNull ActionListener pListener) {
        this.addActionListener(pListener);
        return this;
    }

    @NotNull
    public MToggle shapeCircle() {
        Icon icon = this.getIcon();
        this.mShape = new Ellipse2D.Float(0.0f, 0.0f, icon.getIconWidth(), icon.getIconHeight());
        return this;
    }

    @NotNull
    public MToggle shape(Shape pShape) {
        this.mShape = pShape;
        return this;
    }

    @Override
    public boolean contains(int pX, int pY) {
        return this.mShape == null ? super.contains(pX, pY) : this.mShape.contains(pX, pY);
    }

    public void setIconBased(boolean pIconBased) {
        this.mIconBased = pIconBased;
    }

    @Override
    public void updateColor() {
        this.setForeground(this.mIconBased ? MCon.colorButtonIconText() : MCon.colorButtonText());
    }

    @Override
    protected void paintComponent(@NotNull Graphics pG) {
        if (!this.mIconBased) {
            if (this.isEnabled()) {
                if (this.getModel().isPressed()) {
                    pG.setColor(MCon.colorButtonPressed());
                } else if (this.getModel().isRollover()) {
                    pG.setColor(MCon.colorButtonHover());
                } else {
                    pG.setColor(MCon.colorButtonNormal());
                }
            } else {
                pG.setColor(MCon.colorButtonDisabled());
            }
            pG.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(pG);
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.title(this.mLangKey);
            if (this.mTip != null) {
                this.mTip.updateLang(this, "to.tt." + this.mLangKey);
            }
        }
    }

    @Override
    @NotNull
    public MToggle title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setText(MLangManager.get("to." + pTitle));
        this.setName(pTitle);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MToggle text(@NotNull String pText) {
        this.setText(pText);
        this.updatePrefWidth();
        return this;
    }

    @Override
    @NotNull
    public MToggle name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    @NotNull
    public MToggle tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MToggle title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this, "to.tt." + pTitle);
        return this.title(pTitle);
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public int prefWidth() {
        if (this.mIconBased) {
            int width = 0;
            if (this.getIcon() != null) {
                width = this.getIcon().getIconWidth();
            }
            if (!this.getText().isEmpty()) {
                width = Math.max(Util.getMetrics(this.getFont()).stringWidth(this.getText()), width);
            }
            return width;
        }
        return Util.getMetrics(this.getFont()).stringWidth(this.getText()) + 50;
    }

    @Override
    public int prefHeight() {
        if (this.mIconBased) {
            int height = 0;
            if (this.getIcon() != null) {
                height = this.getIcon().getIconHeight();
            }
            if (!this.getText().isEmpty()) {
                height = Math.max(Util.getMetrics(this.getFont()).getHeight(), height);
            }
            return height;
        }
        return Util.getMetrics(this.getFont()).getHeight();
    }

    @Override
    public void setFont(Font pFont) {
        super.setFont(pFont);
        this.updatePref();
    }

    @Override
    public void setIcon(Icon pIcon) {
        super.setIcon(pIcon);
        this.updatePref();
    }

    public int getPrefWidth() {
        return this.mPos.getPrefWidth();
    }

    public int getPrefHeight() {
        return this.mPos.getPrefHeight();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MToggle retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MToggle)MReflection.retrieveComp(pView, pPath, MToggle.class);
    }
}

