/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.filter;

import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mlog.MLog;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MFeedback {
    @NotNull
    private final AtomicBoolean mRunning = new AtomicBoolean(false);
    private JComponent mComp;
    private boolean mShown;

    public MFeedback(JComponent pComp) {
        this.mComp = pComp;
    }

    public void show() {
        this.mShown = true;
        this.blink();
        this.toolTip();
    }

    public void hide() {
        this.mShown = false;
        this.mComp.setBorder(this.mComp.isFocusOwner() ? MCon.borderFieldFocus() : MCon.borderField());
        this.toolTip();
    }

    private void toolTip() {
        Action toolTip = this.mComp.getActionMap().get("postTip");
        if (toolTip != null) {
            toolTip.actionPerformed(new ActionEvent(this.mComp, 1001, ""));
        }
    }

    private void blink() {
        if (this.mRunning.compareAndSet(false, true)) {
            new Thread(() -> {
                for (int i = 0; i < 4; ++i) {
                    if (i % 2 == 0) {
                        this.mComp.setBorder(MCon.borderFieldWrongInput());
                    } else {
                        this.mComp.setBorder(this.mComp.isFocusOwner() ? MCon.borderFieldFocus() : MCon.borderField());
                    }
                    try {
                        Thread.sleep(400L);
                        continue;
                    }
                    catch (InterruptedException pE) {
                        MLog.log(pE);
                    }
                }
                this.mRunning.set(false);
            }).start();
        }
    }

    public void setComp(JComponent pComp) {
        this.mComp = pComp;
    }

    public boolean isShown() {
        return this.mShown;
    }
}

