/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.filter.check;

import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.filter.check.ICheckable;
import de.maggicraft.mgui.filter.check.MCheckSign;
import org.jetbrains.annotations.NotNull;

public class MCheckCombo
implements ICheckable {
    @NotNull
    private final MCombo mCombo;
    private final int mInvalidIndex;
    @NotNull
    private final MCheckSign mCheckSign;

    public MCheckCombo(@NotNull MCombo pCombo, int pInvalidIndex) {
        this.mCombo = pCombo;
        this.mInvalidIndex = pInvalidIndex;
        this.mCheckSign = new MCheckSign(pCombo, null);
        pCombo.addListener(pEvent -> this.hideOnShown());
    }

    private void hideOnShown() {
        if (this.mCheckSign.isShown() && this.isValid()) {
            this.mCheckSign.hide();
        }
    }

    @Override
    @NotNull
    public MCheckCombo title(String pTitle) {
        this.mCheckSign.title(pTitle);
        return this;
    }

    @Override
    @NotNull
    public MCheckCombo text(String pText) {
        this.mCheckSign.text(pText);
        return this;
    }

    @Override
    public void showFeedback() {
        this.mCheckSign.show();
    }

    @Override
    public boolean isValid() {
        return this.mCombo.getSelectedIndex() != this.mInvalidIndex;
    }

    @Override
    @NotNull
    public MCheckSign getCheckSign() {
        return this.mCheckSign;
    }
}

