/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.filter.check;

import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.filter.check.ICheckable;
import de.maggicraft.mgui.filter.check.MCheckSign;
import de.maggicraft.mgui.filter.types.MFilterField;
import de.maggicraft.mgui.pos.MMPos;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.jetbrains.annotations.NotNull;

public class MCheckField
extends MFilterField
implements ICheckable {
    @NotNull
    private final MCheckSign mCheckSign;
    private boolean mPlaceholderValid;

    public MCheckField(@NotNull MField pField, @NotNull MFilter pFilter) {
        this(pField, pFilter, null);
    }

    public MCheckField(@NotNull MField pField, @NotNull MFilter pFilter, MMPos pPos) {
        super(pField, pFilter);
        this.mCheckSign = new MCheckSign(pField, pPos);
    }

    @Override
    @NotNull
    public MCheckField title(String pTitle) {
        this.mCheckSign.title(pTitle);
        return this;
    }

    @Override
    @NotNull
    public MCheckField text(String pText) {
        this.mCheckSign.text(pText);
        return this;
    }

    @Override
    public void remove(@NotNull DocumentFilter.FilterBypass pBypass, int pOffset, int pLength) throws BadLocationException {
        super.remove(pBypass, pOffset, pLength);
        this.hideOnShown();
    }

    @Override
    public void insertString(@NotNull DocumentFilter.FilterBypass pBypass, int pOffset, @NotNull String pText, AttributeSet pAttr) throws BadLocationException {
        super.insertString(pBypass, pOffset, pText, pAttr);
        this.hideOnShown();
    }

    @Override
    public void replace(@NotNull DocumentFilter.FilterBypass pBypass, int pOffset, int pLength, @NotNull String pText, AttributeSet pAttr) throws BadLocationException {
        super.replace(pBypass, pOffset, pLength, pText, pAttr);
        this.hideOnShown();
    }

    private void hideOnShown() {
        if (this.mCheckSign.isShown() && this.isValid()) {
            this.mCheckSign.hide();
        }
    }

    @Override
    public void showFeedback() {
        this.mCheckSign.show();
    }

    @Override
    public boolean isValid() {
        String text = this.mField.getText();
        return !text.isEmpty() && (this.mPlaceholderValid || !this.mField.getPlaceholder().equals(text)) && this.mFilter.isValid(text);
    }

    public void setPlaceholderValid(boolean pPlaceholderValid) {
        this.mPlaceholderValid = pPlaceholderValid;
    }

    @Override
    @NotNull
    public MCheckSign getCheckSign() {
        return this.mCheckSign;
    }
}

