/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.filter.check;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.view.MDialogs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCheckSign {
    @NotNull
    private final MButton mButton;
    private String mText;
    private boolean mTitle;

    public MCheckSign(@NotNull IComp pComp) {
        this(pComp, null);
    }

    public MCheckSign(@NotNull IComp pComp, @Nullable MMPos pPos) {
        if (pPos == null) {
            pPos = MPos.pos("[]30<>,||<>s<>", pComp);
        }
        this.mButton = new MButton(pPos).addAction(pEvent -> MDialogs.makeNote(MPos.getFrame(pComp), this.getText())).text("!");
        this.mButton.setIconBased(true);
        this.mButton.setOpaque(true);
        this.mButton.setForeground(MCon.colorHintForeground());
        this.mButton.setBackground(MCon.colorHintBackground());
        this.mButton.setVisible(false);
    }

    @NotNull
    public MCheckSign title(String pKey) {
        this.mText = pKey;
        this.mTitle = true;
        this.mButton.tip(new MTip(this.getText()));
        return this;
    }

    @NotNull
    public MCheckSign text(String pText) {
        this.mText = pText;
        this.mTitle = false;
        this.mButton.tip(new MTip(this.getText()));
        return this;
    }

    @NotNull
    private String getText() {
        return this.mTitle ? MLangManager.get("hi." + this.mText) : this.mText;
    }

    public boolean isShown() {
        return this.mButton.isVisible();
    }

    public void show() {
        this.mButton.setVisible(true);
    }

    public void hide() {
        this.mButton.setVisible(false);
    }

    @NotNull
    public MButton getButton() {
        return this.mButton;
    }
}

