/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.filter.check;

import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.filter.check.ICheckable;
import de.maggicraft.mgui.filter.check.MCheckCombo;
import de.maggicraft.mgui.filter.check.MCheckField;
import de.maggicraft.mgui.util.MTip;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class MChecker {
    @NotNull
    private final LinkedList<ICheckable> mCheckables = new LinkedList();

    public void add(ICheckable pCheckable) {
        this.mCheckables.add(pCheckable);
    }

    public void add(@NotNull MFilter pFilter, MField ... pFields) {
        this.add(pFilter, false, pFields);
    }

    public void add(@NotNull MFilter pFilter, boolean pPlaceholderValid, MField ... pFields) {
        for (MField field : pFields) {
            MCheckField checkable = new MCheckField(field, pFilter);
            checkable.setPlaceholderValid(pPlaceholderValid);
            String desc = pFilter.desc();
            checkable.getCheckSign().getButton().tip(new MTip(desc));
            checkable.getCheckSign().text(desc);
            this.mCheckables.add(checkable);
        }
    }

    public void add(int pInvalidIndex, @NotNull MCombo pCombo, @NotNull String pTip) {
        pCombo.tip(new MTip(pTip));
        MCheckCombo checkable = new MCheckCombo(pCombo, pInvalidIndex);
        checkable.getCheckSign().getButton().tip(new MTip(pTip));
        checkable.getCheckSign().text(pTip);
        this.mCheckables.add(checkable);
    }

    public void clearCheckables() {
        this.mCheckables.clear();
    }

    public boolean remove(ICheckable pCheckable) {
        return this.mCheckables.remove(pCheckable);
    }

    public boolean check() {
        boolean valid = true;
        for (ICheckable checkable : this.mCheckables) {
            if (checkable.isValid()) continue;
            checkable.showFeedback();
            valid = false;
        }
        return valid;
    }
}

