/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.filter.types;

import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.filter.MFeedback;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.jetbrains.annotations.NotNull;

public class MFilterField
extends DocumentFilter {
    protected final MField mField;
    @NotNull
    protected final MFilter mFilter;
    @NotNull
    private final MFeedback mFeedback;

    public MFilterField(MField pField, MFilter pFilter) {
        this.mField = pField;
        this.mField.tip(new MTip(pFilter.desc()));
        this.mField.setHasFilter(true);
        this.mFeedback = new MFeedback(pField);
        this.mFilter = pFilter;
        this.mField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent pE) {
                if (MFilterField.this.mFeedback.isShown()) {
                    MFilterField.this.focusGained();
                } else {
                    MFilterField.this.mField.setPrevText(MFilterField.this.mField.getText());
                    if (MFilterField.this.mField.isClearWithFocus() || MFilterField.this.mField.getText().equals(MFilterField.this.mField.getPlaceholder())) {
                        MFilterField.this.mField.setText("");
                        MFilterField.this.mField.setForeground(MCon.colorFieldText());
                        MFilterField.this.mField.setFont(MCon.fontField());
                    }
                    MFilterField.this.mField.setBackground(MCon.colorFieldBackgroundFocus());
                    MFilterField.this.mField.setBorder(MCon.borderFieldFocus());
                }
            }

            @Override
            public void focusLost(FocusEvent pE) {
                if (MFilterField.this.mFeedback.isShown()) {
                    MFilterField.this.focusLost();
                } else {
                    if (MFilterField.this.mField.getText().isEmpty()) {
                        MFilterField.this.mField.setText(MFilterField.this.mField.getPlaceholder());
                        MFilterField.this.mField.setForeground(MCon.colorFieldTextPlaceholder());
                        MFilterField.this.mField.setFont(MCon.fontFieldPlaceholder());
                    }
                    MFilterField.this.mField.setBackground(MCon.colorFieldBackground());
                    MFilterField.this.mField.setBorder(MCon.borderField());
                }
            }
        });
        ((AbstractDocument)this.mField.getDocument()).setDocumentFilter(this);
    }

    private void focusGained() {
        this.mField.setPrevText(this.mField.getText());
        if (this.mField.isClearWithFocus() || this.mField.getText().equals(this.mField.getPlaceholder())) {
            this.mField.setText("");
            this.mField.setForeground(MCon.colorFieldText());
            this.mField.setFont(MCon.fontField());
        }
        this.mField.setBackground(MCon.colorFieldBackgroundFocus());
    }

    private void focusLost() {
        if (this.mField.getText().isEmpty()) {
            this.mField.setText(this.mField.getPlaceholder());
            this.mField.setForeground(MCon.colorFieldTextPlaceholder());
            this.mField.setFont(MCon.fontFieldPlaceholder());
        }
        this.mField.setBackground(MCon.colorFieldBackground());
    }

    @Override
    public void remove(@NotNull DocumentFilter.FilterBypass pBypass, int pOffset, int pLength) throws BadLocationException {
        this.validCapture(Util.removed(this.mField.getText(), pOffset, pLength), "");
        super.remove(pBypass, pOffset, pLength);
    }

    @Override
    public void insertString(@NotNull DocumentFilter.FilterBypass pBypass, int pOffset, @NotNull String pText, AttributeSet pAttr) throws BadLocationException {
        super.insertString(pBypass, pOffset, this.validCapture(this.mField.getText(), pText), pAttr);
    }

    @Override
    public void replace(@NotNull DocumentFilter.FilterBypass pBypass, int pOffset, int pLength, @NotNull String pText, AttributeSet pAttr) throws BadLocationException {
        super.replace(pBypass, pOffset, pLength, this.validCapture("", pText), pAttr);
    }

    @NotNull
    private String validCapture(@NotNull String pBase, String pStr) {
        if (pStr.equals(this.mField.getPlaceholder())) {
            return pStr;
        }
        if (pBase.equals(this.mField.getPlaceholder())) {
            pBase = "";
        }
        String valid = this.mFilter.validate(pBase + pStr);
        if (pStr.equals(this.mField.getPlaceholder()) || valid.length() == pStr.length() + pBase.length()) {
            if (this.mFeedback.isShown()) {
                this.mFeedback.hide();
            }
        } else if (!this.mFeedback.isShown()) {
            this.mFeedback.show();
        }
        return valid.substring(pBase.length());
    }
}

