/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.listener;

import de.maggicraft.mgui.comp.MRadio;
import de.maggicraft.mgui.comp.MSwitcher;
import de.maggicraft.mgui.listener.IListenable;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompBool {
    @NotNull
    private final List<IListenable<?, Boolean, ItemEvent>> mListeners;
    private boolean mValue;

    public CompBool(boolean pValue) {
        this.mValue = pValue;
        this.mListeners = new LinkedList();
    }

    public MRadio addComp(@NotNull MRadio pRadio) {
        return this.addComp(pRadio, null);
    }

    public MRadio addComp(@NotNull MRadio pRadio, @Nullable Runnable pAfter) {
        this.mListeners.add(pRadio);
        pRadio.setSelected(this.mValue);
        pRadio.addListener(pEvent -> {
            this.setValue(pRadio.isSelected());
            if (pAfter != null) {
                pAfter.run();
            }
        });
        return pRadio;
    }

    public MSwitcher addComp(@NotNull MSwitcher pSwitcher) {
        return this.addComp(pSwitcher, null);
    }

    public MSwitcher addComp(@NotNull MSwitcher pSwitcher, @Nullable Runnable pAfter) {
        this.mListeners.add(pSwitcher);
        pSwitcher.setSelected(this.mValue);
        pSwitcher.addListener(pEvent -> {
            this.setValue(pSwitcher.isSelected());
            if (pAfter != null) {
                pAfter.run();
            }
        });
        return pSwitcher;
    }

    public boolean isValue() {
        return this.mValue;
    }

    public void setValue(boolean pValue) {
        this.mValue = pValue;
        for (IListenable<?, Boolean, ItemEvent> listener : this.mListeners) {
            listener.setValueVoid(pValue);
        }
    }

    public boolean remove(IListenable<?, Boolean, ItemEvent> pListenable) {
        return this.mListeners.remove(pListenable);
    }

    public List<IListenable<?, Boolean, ItemEvent>> getListeners() {
        return this.mListeners;
    }
}

