/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.listener;

import de.maggicraft.mcommons.filter.types.MFilters;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.comp.MSlider;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompInt {
    @NotNull
    private final LinkedList<IComp> mComps;
    private int mValue;

    public CompInt(int pValue) {
        this.mValue = pValue;
        this.mComps = new LinkedList();
    }

    public MCombo addComp(@NotNull MCombo pCombo) {
        return this.addComp(pCombo, null);
    }

    public MCombo addComp(@NotNull MCombo pCombo, Runnable pAfter) {
        this.mComps.add(pCombo);
        pCombo.setSelectedIndex(this.mValue);
        pCombo.addListener(pEvent -> {
            this.setValue(pCombo.getSelectedIndex());
            if (pAfter != null) {
                pAfter.run();
            }
        });
        return pCombo;
    }

    public MField addComp(@NotNull MField pField) {
        return this.addComp(pField, null);
    }

    public MField addComp(@NotNull MField pField, Runnable pAfter) {
        this.mComps.add(pField);
        pField.filter(MFilters.FILTER_INTEGER);
        pField.text(Integer.toString(this.mValue));
        pField.addListener(pEvent -> {
            this.mValue = Integer.parseInt(pField.getText());
            if (pAfter != null) {
                pAfter.run();
            }
        });
        return pField;
    }

    public MSlider addComp(@NotNull MSlider pSlider) {
        return this.addComp(pSlider, null);
    }

    public MSlider addComp(@NotNull MSlider pSlider, Runnable pAfter) {
        this.mComps.add(pSlider);
        pSlider.setValue(this.mValue);
        pSlider.addListener(pEvent -> {
            this.setValue(pSlider.getValue());
            if (pAfter != null) {
                pAfter.run();
            }
        });
        return pSlider;
    }

    public int getValue() {
        return this.mValue;
    }

    public void setValue(int pValue) {
        this.mValue = pValue;
        for (IComp comp : this.mComps) {
            if (comp instanceof MCombo) {
                ((MCombo)comp).setValueVoid(pValue);
                continue;
            }
            if (comp instanceof MField) {
                ((MField)comp).setValueVoid(Integer.toString(pValue));
                continue;
            }
            if (comp instanceof MSlider) {
                ((MSlider)comp).setValueVoid(pValue);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    public boolean remove(IComp pComp) {
        return this.mComps.remove(pComp);
    }

    public List<IComp> getComps() {
        return this.mComps;
    }
}

