/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.menu;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.menu.MMenuItem;
import de.maggicraft.mgui.menu.MSeparator;
import de.maggicraft.mgui.schemes.MCon;
import javax.swing.JMenu;
import org.jetbrains.annotations.NotNull;

public class MMenu
extends JMenu {
    private String mLangKey;

    public MMenu() {
        this.setFont(MCon.fontCombo());
        this.setBorder(MCon.borderMenuItem());
        this.getPopupMenu().setBorder(MCon.borderMenu());
        this.updateColor();
    }

    public void updateLang() {
        if (this.mLangKey != null) {
            this.title(this.mLangKey);
        }
    }

    public void updateColor() {
        this.setForeground(MCon.colorMenuForeground());
        this.setBackground(MCon.colorMenuBackground());
        this.getPopupMenu().setBackground(MCon.colorMenuBackground());
    }

    @Override
    @NotNull
    public MMenuItem add(String pText) {
        MMenuItem item = new MMenuItem().text(pText);
        this.add(item);
        return item;
    }

    @NotNull
    public MMenu addSub() {
        MMenu menu = new MMenu();
        this.add(menu);
        return menu;
    }

    @NotNull
    public MMenu addSub(String pText) {
        MMenu menu = new MMenu().text(pText);
        this.add(menu);
        return menu;
    }

    @NotNull
    public MMenu addSep() {
        this.add(new MSeparator());
        return this;
    }

    @NotNull
    public MMenu text(String pText) {
        this.setText(pText);
        return this;
    }

    @NotNull
    public MMenu title(String pTitle) {
        this.mLangKey = pTitle;
        this.setText(MLangManager.get("me." + pTitle));
        return this;
    }
}

