/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.menu;

import de.maggicraft.mcommons.util.MTuple;
import de.maggicraft.mgui.menu.IMenuListener;
import de.maggicraft.mgui.menu.MMenu;
import de.maggicraft.mgui.menu.MMenuItem;
import de.maggicraft.mgui.menu.MMenuManager;
import de.maggicraft.mgui.menu.MSeparator;
import de.maggicraft.mgui.schemes.MCon;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;

public class MPopupMenu
extends JPopupMenu {
    private LinkedList<IMenuListener> mShowListener;
    @NotNull
    private LinkedList<MTuple<Component, MouseListener>> mMouseListeners = new LinkedList();
    @NotNull
    private final LinkedList<JMenuItem> mComps = new LinkedList();

    public MPopupMenu() {
        MMenuManager.add(this);
        this.setBorder(MCon.borderMenu());
        this.updateColor();
    }

    public void updateLang() {
        for (JMenuItem comp : this.mComps) {
            if (comp instanceof MMenu) {
                ((MMenu)comp).updateLang();
                continue;
            }
            if (!(comp instanceof MMenuItem)) continue;
            ((MMenuItem)comp).updateLang();
        }
    }

    public void updateColor() {
        this.setBackground(MCon.colorMenuBackground());
    }

    @Override
    @NotNull
    public MMenuItem add(String pText) {
        MMenuItem item = new MMenuItem().text(pText);
        this.mComps.add(item);
        this.add(item);
        return item;
    }

    @NotNull
    public MMenu addSub() {
        MMenu menu = new MMenu();
        this.mComps.add(menu);
        this.add(menu);
        return menu;
    }

    @NotNull
    public MMenu addSub(String pText) {
        MMenu menu = new MMenu().text(pText);
        this.mComps.add(menu);
        this.add(menu);
        return menu;
    }

    @NotNull
    public MPopupMenu addSep() {
        this.add(new MSeparator());
        return this;
    }

    public void addToContainer(@NotNull Container pCon) {
        for (int i = 0; i < pCon.getComponentCount(); ++i) {
            if (pCon.getComponent(i) instanceof Container) {
                this.addToContainer((Container)pCon.getComponent(i));
                continue;
            }
            this.addToComp(pCon.getComponent(i));
        }
        this.addToComp(pCon);
    }

    public void addToComp(Component ... pComp) {
        for (Component comp : pComp) {
            MouseAdapter listener = new MouseAdapter(){

                @Override
                public void mouseClicked(@NotNull MouseEvent pEvent) {
                    MPopupMenu.this.rightClick(pEvent);
                }
            };
            this.mMouseListeners.add(new MTuple<Component, 1>(comp, listener));
            comp.addMouseListener(listener);
        }
    }

    private void rightClick(MouseEvent pEvent) {
        if (pEvent.getButton() == 3) {
            JComponent comp = (JComponent)pEvent.getSource();
            comp.requestFocus();
            this.show(comp, pEvent.getX(), pEvent.getY());
        }
    }

    @Override
    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
        if (this.mShowListener != null) {
            for (IMenuListener listener : this.mShowListener) {
                listener.shown();
            }
        }
    }

    public void addMenuListener(IMenuListener pMenuListener) {
        if (this.mShowListener == null) {
            this.mShowListener = new LinkedList();
        }
        this.mShowListener.add(pMenuListener);
    }

    public void deinit() {
        for (MTuple mTuple : this.mMouseListeners) {
            ((Component)mTuple.getA()).removeMouseListener((MouseListener)mTuple.getB());
        }
        this.mMouseListeners = new LinkedList();
    }
}

