/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.pos;

import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.ICompound;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.view.MView;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Container;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LPos
extends MPos {
    private int mLayer;

    protected LPos(@NotNull char[] pPos, @NotNull IView pView, @NotNull IComp pCompH, @NotNull IComp pCompV, int pCur, int pLayer) {
        super(pPos, pView, pCompH, pCompV, pCur);
        this.mLayer = pLayer;
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static LPos pos(@NotNull String pPos, @NotNull IComp pComp, int pLayer) {
        char[] pos = pPos.toCharArray();
        if (pos[0] == 'H') {
            return new LPos(pos, pComp.getPos().mView, pComp, LPos.getMFrame(pComp), 1, pLayer);
        }
        if (pos[0] == 'V') {
            return new LPos(pos, pComp.getPos().mView, LPos.getMFrame(pComp), pComp, 1, pLayer);
        }
        return new LPos(pos, pComp.getPos().mView, pComp, pComp, pos[0] == 'B' ? 1 : 0, pLayer);
    }

    @NotNull
    @Contract(value="_, _, _, _ -> new")
    public static LPos pos(@NotNull String pPos, @NotNull IComp pCompH, @NotNull IComp pCompV, int pLayer) {
        IView view = pCompH.getPos().mView;
        char[] pos = pPos.toCharArray();
        if (view != pCompV.getPos().mView || pos[0] >= 'A' && pos[0] <= 'Z') {
            throw new IllegalArgumentException();
        }
        return new LPos(pos, view, pCompH, pCompV, 0, pLayer);
    }

    @NotNull
    @Contract(value="_, _, _, _, _ -> new")
    public static LPos pos(@NotNull IView pView, @NotNull String pPos, @NotNull IComp pCompH, @NotNull IComp pCompV, int pLayer) {
        return new LPos(pPos.toCharArray(), pView, pCompH, pCompV, 0, pLayer);
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static LPos pos(@NotNull IView pView, @NotNull String pPos, int pLayer) {
        return new LPos(pPos.toCharArray(), pView, pView, pView, 0, pLayer);
    }

    @Override
    @NotNull
    public MMPos addComp(@NotNull IComp pComp) {
        this.mComp = pComp;
        if (pComp instanceof ICompound) {
            if (this.mView instanceof Container) {
                ((ICompound)((Object)pComp)).addTo((Container)((Object)this.mView));
            } else {
                String exc = "IView instance " + this.mView.getName() + " doesn't inherit from container";
                throw new IllegalArgumentException(exc);
            }
        }
        if (this.mView instanceof MView) {
            ((MView)this.mView).add(this.mComp, this.mLayer);
        } else {
            this.mView.add(this.mComp);
        }
        return this;
    }

    public int getLayer() {
        return this.mLayer;
    }
}

