/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.pos;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.ICompound;
import de.maggicraft.mgui.util.MDebugInfo;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Container;
import org.jetbrains.annotations.NotNull;

public class MMPos {
    @NotNull
    protected final IView mView;
    protected IComp mComp;
    protected char mWidthPref;
    protected char mHeightPref;

    public MMPos(@NotNull IView pView) {
        this.mView = pView;
    }

    public void updateView() {
        this.mView.update();
    }

    @NotNull
    public MMPos addComp(@NotNull IComp pComp) {
        this.mComp = pComp;
        if (pComp instanceof ICompound) {
            if (this.mView instanceof Container) {
                ((ICompound)((Object)pComp)).addTo((Container)((Object)this.mView));
            } else {
                String exc = "IView instance " + this.mView.getName() + " doesn't inherit from container";
                throw new IllegalArgumentException(exc);
            }
        }
        this.mView.add(this.mComp);
        return this;
    }

    public void updateComp(int pX, int pY, int pWidth, int pHeight) {
    }

    @NotNull
    public IView getView() {
        return this.mView;
    }

    @NotNull
    public IComp getComp() {
        return this.mComp;
    }

    public void setComp(@NotNull IComp pComp) {
        this.mComp = pComp;
    }

    public boolean isPrefH() {
        return false;
    }

    public boolean isPrefV() {
        return false;
    }

    public char getPrefWidth() {
        return this.mWidthPref;
    }

    public void setPrefWidth(int pPrefWidth) {
        this.mWidthPref = (char)pPrefWidth;
    }

    public char getPrefHeight() {
        return this.mHeightPref;
    }

    public void setPrefHeight(int pPrefHeight) {
        this.mHeightPref = (char)pPrefHeight;
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append('\t').append("parent: ").append(this.mView.getName()).append('\t').append(MDebugInfo.getInitLocation(this.mView)).append(CCon.LINE_SEP);
        sb.append('\t').append("width - pref: ").append((int)this.mWidthPref).append(CCon.LINE_SEP);
        sb.append('\t').append("height - pref: ").append((int)this.mHeightPref).append(CCon.LINE_SEP);
        return sb.toString();
    }
}

