/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.pos;

import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.comp.MPictureMode;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.view.MFrame;
import de.maggicraft.mgui.view.util.IView;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class MPicPos
extends MPos {
    private MPicture mPicture;

    public static MPicPos pos(@NotNull String pPos, @NotNull IComp pComp) {
        char[] pos = pPos.toCharArray();
        if (pos[0] == 'H') {
            return new MPicPos(pos, pComp.getPos().mView, pComp, MPicPos.getMFrame(pComp), 1);
        }
        if (pos[0] == 'V') {
            return new MPicPos(pos, pComp.getPos().mView, MPicPos.getMFrame(pComp), pComp, 1);
        }
        return new MPicPos(pos, pComp.getPos().mView, pComp, pComp, pos[0] == 'B' ? 1 : 0);
    }

    public static MPicPos pos(@NotNull IView pView, @NotNull String pPos) {
        return new MPicPos(pPos.toCharArray(), pView, pView, pView, 0);
    }

    public static MPicPos pos(@NotNull String pPos, @NotNull IComp pCompH, @NotNull IComp pCompV) {
        IView view = pCompH.getPos().mView;
        char[] pos = pPos.toCharArray();
        if (view != pCompV.getPos().mView || pos[0] >= 'A' && pos[0] <= 'Z') {
            throw new IllegalArgumentException();
        }
        return new MPicPos(pos, view, pCompH, pCompV, 0);
    }

    public static MPicPos pos(@NotNull IView pView, @NotNull String pPos, @NotNull IComp pCompH, @NotNull IComp pCompV) {
        return new MPicPos(pPos.toCharArray(), pView, pCompH, pCompV, 0);
    }

    private MPicPos(@NotNull char[] pPos, @NotNull IView pView, @NotNull IComp pCompH, @NotNull IComp pCompV, int pCur) {
        super(pPos, pView, pCompH, pCompV, pCur);
    }

    @Override
    public void updateComp(int pX, int pY, int pWidth, int pHeight) {
        MPictureMode mode;
        int height;
        int oriY;
        int width;
        int oriX;
        if (this.mCompH instanceof MFrame || this.mCompH == this.mView) {
            oriX = pX;
            width = pWidth;
        } else {
            oriX = this.mCompH.getX();
            width = this.mCompH.getWidth();
        }
        oriX += this.is(16) ? width / 2 : (this.is(32) ? width : 0);
        if (this.is(16384)) {
            width = this.mWidthMin;
        } else {
            int n = width = this.is(4096) ? (int)this.mWidthPref : pWidth;
            width = width > this.mWidthMax ? this.mWidthMax : (width < this.mWidthMin ? (int)this.mWidthMin : width);
        }
        int posX = this.is(1) ? oriX + this.mGapWest : (this.is(2) ? oriX - width / 2 : oriX - width - this.mGapEast);
        if ((this.is(4) || this.is(2)) && posX < this.mGapWest) {
            width -= Math.abs(posX - this.mGapWest);
            posX = Math.min(this.mGapWest, pWidth);
        }
        if (posX + width + this.mGapEast > pWidth && (width = pWidth - this.mGapEast - posX) < -this.mGapWest) {
            width = -this.mGapWest;
        }
        if (this.mCompV instanceof MFrame || this.mCompV == this.mView) {
            oriY = pY;
            height = pHeight;
        } else {
            oriY = this.mCompV.getY();
            height = this.mCompV.getHeight();
        }
        oriY += this.is(1024) ? height / 2 : (this.is(2048) ? height : 0);
        height = this.is(131072) ? (int)this.mHeightMin : (int)((height = this.is(32768) ? (int)this.mHeightPref : pHeight) > this.mHeightMax ? this.mHeightMax : (height < this.mHeightMin ? (int)this.mHeightMin : height));
        int posY = this.is(64) ? oriY + this.mGapNorth : (this.is(128) ? oriY - height / 2 : oriY - height - this.mGapSouth);
        if ((this.is(256) || this.is(128)) && posY < this.mGapNorth) {
            height -= Math.abs(posY - this.mGapNorth);
            posY = Math.min(this.mGapNorth, pHeight);
        }
        if (posY + height + this.mGapSouth > pHeight && (height = pHeight - this.mGapSouth - posY) < -this.mGapNorth) {
            height = -this.mGapNorth;
        }
        if ((mode = this.mPicture.getMode()) != MPictureMode.CUT) {
            int imgWidth = width;
            int imgHeight = height;
            if (mode != MPictureMode.RESIZE) {
                ImageIcon iconSource = this.mPicture.getIconSource();
                if (mode == MPictureMode.RESIZE_PROP) {
                    double ratio = Math.min((double)width / (double)iconSource.getIconWidth(), (double)height / (double)iconSource.getIconHeight());
                    width = (int)((double)iconSource.getIconWidth() * ratio);
                    if (width <= 0) {
                        width = 1;
                    }
                    if ((height = (int)((double)iconSource.getIconHeight() * ratio)) <= 0) {
                        height = 1;
                    }
                    imgWidth = width;
                    imgHeight = height;
                } else if (mode == MPictureMode.FIT_WIDTH) {
                    imgHeight = (int)((double)iconSource.getIconHeight() * (double)width / (double)iconSource.getIconWidth());
                } else if (mode == MPictureMode.FIT_HEIGHT) {
                    imgWidth = (int)((double)iconSource.getIconWidth() * (double)height / (double)iconSource.getIconHeight());
                }
            }
            this.mPicture.queryResize(imgWidth, imgHeight);
        }
        this.mPicture.setBounds(posX, posY, width, height);
    }

    public void setComp(@NotNull MPicture pComp) {
        this.mComp = pComp;
        this.mPicture = pComp;
    }

    @NotNull
    public MMPos addComp(@NotNull MPicture pComp) {
        this.mComp = pComp;
        this.mPicture = pComp;
        this.mView.add(this.mComp);
        return this;
    }
}

