/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.pos;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.PosParser;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MDebugInfo;
import de.maggicraft.mgui.view.MDialog;
import de.maggicraft.mgui.view.MFrame;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Container;
import java.awt.Frame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MPos
extends MMPos {
    @NotNull
    protected final IComp mCompH;
    @NotNull
    protected final IComp mCompV;
    protected int mProp;
    protected char mWidthMin;
    protected char mWidthMax;
    protected char mHeightMin;
    protected char mHeightMax;
    protected short mGapNorth;
    protected short mGapEast;
    protected short mGapSouth;
    protected short mGapWest;

    protected MPos(@NotNull char[] pPos, @NotNull IView pView, @NotNull IComp pCompH, @NotNull IComp pCompV, int pCur) {
        super(pView);
        this.mCompH = pCompH;
        this.mCompV = pCompV;
        this.init(pPos, pCur);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static MPos pos(@NotNull String pPos, @NotNull IComp pComp) {
        char[] pos = pPos.toCharArray();
        if (pos[0] == 'H') {
            return new MPos(pos, pComp.getPos().mView, pComp, MPos.getMFrame(pComp), 1);
        }
        if (pos[0] == 'V') {
            return new MPos(pos, pComp.getPos().mView, MPos.getMFrame(pComp), pComp, 1);
        }
        return new MPos(pos, pComp.getPos().mView, pComp, pComp, pos[0] == 'B' ? 1 : 0);
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static MPos pos(@NotNull String pPos, @NotNull IComp pCompH, @NotNull IComp pCompV) {
        IView view = pCompH.getPos().mView;
        char[] pos = pPos.toCharArray();
        if (view != pCompV.getPos().mView || pos[0] >= 'A' && pos[0] <= 'Z') {
            throw new IllegalArgumentException();
        }
        return new MPos(pos, view, pCompH, pCompV, 0);
    }

    @NotNull
    @Contract(value="_, _, _, _ -> new")
    public static MPos pos(@NotNull IView pView, @NotNull String pPos, @NotNull IComp pCompH, @NotNull IComp pCompV) {
        return new MPos(pPos.toCharArray(), pView, pCompH, pCompV, 0);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static MPos pos(@NotNull IView pView, @NotNull String pPos) {
        return new MPos(pPos.toCharArray(), pView, pView, pView, 0);
    }

    protected void init(@NotNull char[] pPos, int pCur) {
        int[] arr;
        this.setProp(1 << (pPos[pCur] == '[' ? 0 : (pPos[pCur] == '|' ? 1 : 2)));
        this.setProp(1 << (pPos[++pCur] == '[' ? 3 : (pPos[pCur] == '|' ? 4 : 5)));
        if (pPos[++pCur] == '<') {
            if (pPos[++pCur] == '>') {
                this.mGapWest = 0;
            } else {
                arr = PosParser.readNumber(pPos, pCur - 1);
                pCur = arr[0];
                this.mGapWest = (short)arr[1];
            }
            ++pCur;
        } else {
            this.mGapWest = MCon.defaultGap();
        }
        if (pPos[pCur] == 'p' || pPos[pCur] == 'P' || pPos[pCur] == 'm' || pPos[pCur] == 'M') {
            arr = PosParser.read(pPos, pCur);
            this.setProp(pPos[pCur] % 2 == 0 ? 4096 : 8192);
            this.mWidthMin = '\u0000';
            this.mWidthMax = (char)Short.MAX_VALUE;
            if (arr.length == 2) {
                if (pPos[pCur] < 'd') {
                    this.mWidthMax = (char)arr[1];
                } else {
                    this.mWidthMin = (char)arr[1];
                }
            } else if (arr.length == 3) {
                this.mWidthMin = (char)arr[1];
                this.mWidthMax = (char)arr[2];
            }
        } else {
            arr = PosParser.read(pPos, pCur - 1);
            this.setProp(16384);
            this.mWidthMin = this.mWidthMax = (char)arr[1];
        }
        pCur = arr[0];
        if (pPos[pCur] == '<') {
            if (pPos[++pCur] == '>') {
                this.mGapEast = 0;
                pCur += 2;
            } else {
                arr = PosParser.readNumber(pPos, pCur - 1);
                pCur = arr[0] + 2;
                this.mGapEast = (short)arr[1];
            }
        } else {
            this.mGapEast = MCon.defaultGap();
            ++pCur;
        }
        this.setProp(1 << (pPos[pCur] == '[' ? 6 : (pPos[pCur] == '|' ? 7 : 8)));
        this.setProp(1 << (pPos[++pCur] == '[' ? 9 : (pPos[pCur] == '|' ? 10 : 11)));
        if (pPos[++pCur] == '<') {
            if (pPos[++pCur] == '>') {
                this.mGapNorth = 0;
            } else {
                arr = PosParser.readNumber(pPos, pCur - 1);
                pCur = arr[0];
                this.mGapNorth = (short)arr[1];
            }
            ++pCur;
        } else {
            this.mGapNorth = MCon.defaultGap();
        }
        if (pPos[pCur] == 'p' || pPos[pCur] == 'P' || pPos[pCur] == 'm' || pPos[pCur] == 'M') {
            arr = PosParser.read(pPos, pCur);
            this.setProp(pPos[pCur] % 2 == 0 ? 32768 : 65536);
            this.mHeightMin = '\u0000';
            this.mHeightMax = (char)65535;
            if (arr.length == 2) {
                if (pPos[pCur] < 'd') {
                    this.mHeightMax = (char)arr[1];
                } else {
                    this.mHeightMin = (char)arr[1];
                }
            } else if (arr.length == 3) {
                this.mHeightMin = (char)arr[1];
                this.mHeightMax = (char)arr[2];
            }
        } else if (pPos[pCur] == 's') {
            arr = PosParser.read(pPos, pCur);
            this.setProp(131072);
            this.mHeightMax = (char)MCon.standardHeight();
            this.mHeightMin = (char)MCon.standardHeight();
        } else {
            arr = PosParser.read(pPos, pCur - 1);
            this.setProp(131072);
            this.mHeightMax = (char)arr[1];
            this.mHeightMin = (char)arr[1];
        }
        pCur = arr[0];
        if (pCur < pPos.length && pPos[pCur] == '<') {
            if (pPos[++pCur] == '>') {
                this.mGapSouth = 0;
            } else {
                arr = PosParser.readNumber(pPos, pCur - 1);
                this.mGapSouth = (short)arr[1];
            }
        } else {
            this.mGapSouth = MCon.defaultGap();
        }
        if (this.mComp instanceof MDialog && ((MDialog)this.mComp).isResizable()) {
            if (this.mCompH instanceof MDialog) {
                this.mGapEast = (short)(this.mGapEast + 10);
            }
            if (this.mCompV instanceof MDialog) {
                this.mGapSouth = (short)(this.mGapSouth + 10);
            }
        }
    }

    private void setProp(int pAlignment) {
        this.mProp |= pAlignment;
    }

    @Override
    public void updateComp(int pX, int pY, int pWidth, int pHeight) {
        int height;
        int oriY;
        int width;
        int oriX;
        if (this.mCompH instanceof MFrame || this.mCompH == this.mView) {
            oriX = pX;
            width = pWidth;
        } else {
            oriX = this.mCompH.getX();
            width = this.mCompH.getWidth();
        }
        oriX += this.is(16) ? width / 2 : (this.is(32) ? width : 0);
        if (this.is(16384)) {
            width = this.mWidthMin;
        } else {
            int n = width = this.is(4096) ? (int)this.mWidthPref : pWidth;
            width = width > this.mWidthMax ? this.mWidthMax : (width < this.mWidthMin ? (int)this.mWidthMin : width);
        }
        int posX = this.is(1) ? oriX + this.mGapWest : (this.is(2) ? oriX - width / 2 : oriX - width - this.mGapEast);
        if ((this.is(4) || this.is(2)) && posX < this.mGapWest) {
            width -= Math.abs(posX - this.mGapWest);
            posX = Math.min(this.mGapWest, pWidth);
        }
        if (posX + width + this.mGapEast > pWidth && (width = pWidth - this.mGapEast - posX) < -this.mGapWest) {
            width = -this.mGapWest;
        }
        if (this.mCompV instanceof MFrame || this.mCompV == this.mView) {
            oriY = pY;
            height = pHeight;
        } else {
            oriY = this.mCompV.getY();
            height = this.mCompV.getHeight();
        }
        oriY += this.is(1024) ? height / 2 : (this.is(2048) ? height : 0);
        if (this.is(131072)) {
            height = this.mHeightMin;
        } else {
            if (this.is(32768)) {
                if (this.mComp instanceof JTextComponent) {
                    this.mComp.setBounds(0, 0, width, 10);
                    height = ((JTextComponent)((Object)this.mComp)).getPreferredSize().height;
                    this.mHeightPref = (char)height;
                } else {
                    height = this.mHeightPref;
                }
            } else {
                height = pHeight;
            }
            if (height > this.mHeightMax) {
                height = this.mHeightMax;
            } else if (height < this.mHeightMin) {
                height = this.mHeightMin;
            }
        }
        int posY = this.is(64) ? oriY + this.mGapNorth : (this.is(128) ? oriY - height / 2 : oriY - height - this.mGapSouth);
        if ((this.is(256) || this.is(128)) && posY < this.mGapNorth) {
            height -= Math.abs(posY - this.mGapNorth);
            posY = Math.min(this.mGapNorth, pHeight);
        }
        if (posY + height + this.mGapSouth > pHeight && (height = pHeight - this.mGapSouth - posY) < -this.mGapNorth) {
            height = -this.mGapNorth;
        }
        this.mComp.setBounds(posX, posY, width, height);
        if (this.mComp instanceof JScrollPane || this.mComp instanceof JSplitPane) {
            ((Container)((Object)this.mComp)).validate();
        }
    }

    public boolean is(int pAlignment) {
        return (this.mProp & pAlignment) != 0;
    }

    @Override
    public boolean isPrefH() {
        return this.is(4096);
    }

    @Override
    public boolean isPrefV() {
        return this.is(32768);
    }

    public char getWidthMin() {
        return this.mWidthMin;
    }

    public char getWidthMax() {
        return this.mWidthMax;
    }

    public char getHeightMin() {
        return this.mHeightMin;
    }

    public char getHeightMax() {
        return this.mHeightMax;
    }

    public short getGapNorth() {
        return this.mGapNorth;
    }

    public short getGapEast() {
        return this.mGapEast;
    }

    public short getGapSouth() {
        return this.mGapSouth;
    }

    public short getGapWest() {
        return this.mGapWest;
    }

    @NotNull
    protected static IView getMFrame(@NotNull IComp pComp) {
        IView view = pComp.getPos().mView;
        while (!(view instanceof MFrame) && !(view instanceof MDialog)) {
            view = view.getPos().mView;
        }
        return view;
    }

    @NotNull
    public static Frame getFrame(@NotNull IComp pComp) {
        IView view = pComp.getPos().mView;
        while (!(view instanceof Frame)) {
            view = view.getPos().mView;
        }
        return (Frame)((Object)view);
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append('\t').append("parent: ").append(this.mView.getName()).append('\t').append(MDebugInfo.getInitLocation(this.mView)).append(CCon.LINE_SEP);
        sb.append('\t').append("compH: ").append(this.mCompH.getName()).append('\t').append(MDebugInfo.getInitLocation(this.mCompH)).append(CCon.LINE_SEP);
        sb.append('\t').append("compV: ").append(this.mCompV.getName()).append('\t').append(MDebugInfo.getInitLocation(this.mCompV)).append(CCon.LINE_SEP);
        sb.append('\t').append("width - min: ").append((int)this.mWidthMin).append(", pref: ").append((int)this.mWidthPref).append(", max: ").append((int)this.mWidthMax).append(CCon.LINE_SEP);
        sb.append('\t').append("height - min: ").append((int)this.mHeightMin).append(", pref: ").append((int)this.mHeightPref).append(", max: ").append((int)this.mHeightMax).append(CCon.LINE_SEP);
        sb.append('\t').append("gaps - North: ").append(this.mGapNorth).append(", East: ").append(this.mGapEast).append(", South: ").append(this.mGapSouth).append(", West: ").append(this.mGapWest).append(CCon.LINE_SEP);
        sb.append('\t').append("is: ");
        if (this.is(1)) {
            sb.append("H_NEG");
        }
        if (this.is(2)) {
            sb.append(", H_MIDDLE");
        }
        if (this.is(4)) {
            sb.append(", H_POS");
        }
        if (this.is(8)) {
            sb.append(", H_SEC_NEG");
        }
        if (this.is(16)) {
            sb.append(", H_SEC_MIDDLE");
        }
        if (this.is(32)) {
            sb.append(", H_SEC_POS");
        }
        if (this.is(64)) {
            sb.append(", V_NEG");
        }
        if (this.is(128)) {
            sb.append(", V_MIDDLE");
        }
        if (this.is(256)) {
            sb.append(", V_POS");
        }
        if (this.is(512)) {
            sb.append(", V_SEC_NEG");
        }
        if (this.is(1024)) {
            sb.append(", V_SEC_MIDDLE");
        }
        if (this.is(2048)) {
            sb.append(", V_SEC_POS");
        }
        if (this.is(4096)) {
            sb.append(", H_DIM_PREF");
        }
        if (this.is(8192)) {
            sb.append(", H_DIM_MAX");
        }
        if (this.is(16384)) {
            sb.append(", H_DIM_EXACTLY");
        }
        if (this.is(32768)) {
            sb.append(", V_DIM_PREF");
        }
        if (this.is(65536)) {
            sb.append(", V_DIM_MAX");
        }
        if (this.is(131072)) {
            sb.append(", V_DIM_EXACTLY");
        }
        sb.append(CCon.LINE_SEP);
        return sb.toString();
    }
}

