/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.schemes.def;

import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.schemes.types.MSchemeMisc;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mlog.MLog;
import de.maggicraft.mlog.MLogImpl;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.jetbrains.annotations.NotNull;

public class MDefaultMisc
implements MSchemeMisc {
    private static Optional<Cursor> createCursor(String pImgName) {
        Optional<BufferedImage> img = ImgUtil.getGUIBuffered(pImgName);
        if (img.isPresent()) {
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(img.get(), new Point(16, 16), pImgName);
            return Optional.of(cursor);
        }
        return Optional.empty();
    }

    @Override
    public void initLog() {
        MLog.init(new MLogImpl(new File(MCon.appFolder(), "log.txt"), true));
    }

    @Override
    public void initComboStyle() {
        UIManager.put("ComboBox.disabledForeground", MCon.colorComboBackgroundDisabled());
        UIManager.put("ComboBox.disabledBackground", MCon.colorComboForegroundDisabled());
        UIManager.put("ComboBox.selectionForeground", MCon.colorComboSelectForeground());
        UIManager.put("ComboBox.selectionBackground", MCon.colorComboSelectBackground());
        UIManager.put("ComboBox.background", MCon.colorComboBackground());
        UIManager.put("ComboBox.buttonBackground", MCon.colorComboBackground());
        UIManager.put("ComboBox.selectionForeground", MCon.colorComboSelectForeground());
        UIManager.put("ComboBox.foreground", MCon.colorComboText());
    }

    @Override
    public void initToolTipStyle() {
        UIManager.put("ToolTip.foreground", MCon.colorTipForeground());
        UIManager.put("ToolTip.background", MCon.colorTipBackground());
        UIManager.put("ToolTip.border", BorderFactory.createLineBorder(MCon.colorTipForeground()));
        UIManager.put("ToolTip.font", MCon.fontToolTip());
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    @Override
    public void initMenuStyle() {
        UIManager.put("Menu.submenuPopupOffsetX", 0);
        UIManager.put("Menu.submenuPopupOffsetY", -7);
        UIManager.put("Menu.arrowIcon", ImgUtil.getImg(ImgUtil.makeColorChanged(MCon.iconArrowRight(), MCon.colorMenuForeground())));
        UIManager.put("Menu.selectionForeground", MCon.colorMenuForegroundHover());
        UIManager.put("Menu.selectionBackground", MCon.colorMenuBackgroundHover());
    }

    @Override
    public void initMenuItemStyle() {
        UIManager.put("MenuItem.selectionForeground", MCon.colorMenuForegroundHover());
        UIManager.put("MenuItem.selectionBackground", MCon.colorMenuBackgroundHover());
    }

    @Override
    @NotNull
    public Border borderField() {
        return new EmptyBorder(0, 11, 0, 11);
    }

    @Override
    @NotNull
    public Border borderFieldFocus() {
        return new CompoundBorder(this.borderFocus(), new EmptyBorder(0, 9, 0, 9));
    }

    @Override
    @NotNull
    public Border borderFieldWrongInput() {
        return new CompoundBorder(BorderFactory.createLineBorder(MCon.colorFieldWrongInput(), 2), new EmptyBorder(0, 9, 0, 9));
    }

    @Override
    @NotNull
    public Border borderFocus() {
        return BorderFactory.createLineBorder(MCon.colorAccent(), 2);
    }

    @Override
    @NotNull
    public Border borderMenu() {
        return new EmptyBorder(7, 0, 7, 0);
    }

    @Override
    @NotNull
    public Border borderMenuItem() {
        return new EmptyBorder(4, 20, 4, 20);
    }

    @Override
    @NotNull
    public Dimension titleButtonDim() {
        return new Dimension(40, 25);
    }

    @Override
    @NotNull
    public File settingsFile() {
        return new File(MCon.appFolder(), "settings.txt");
    }

    @Override
    @NotNull
    public Highlighter.HighlightPainter textHighlighter() {
        return new DefaultHighlighter.DefaultHighlightPainter(MCon.colorTextHighlight());
    }

    @Override
    @NotNull
    public String decimalMark() {
        return ",";
    }

    @Override
    @NotNull
    public Cursor cursorVertical() {
        Optional<Cursor> cursor = MDefaultMisc.createCursor("cursor_vertical");
        return cursor.orElseGet(Cursor::getDefaultCursor);
    }

    @Override
    @NotNull
    public Cursor cursorHorizontal() {
        Optional<Cursor> cursor = MDefaultMisc.createCursor("cursor_horizontal");
        return cursor.orElseGet(Cursor::getDefaultCursor);
    }

    @Override
    @NotNull
    public Cursor cursorBoth() {
        Optional<Cursor> cursor = MDefaultMisc.createCursor("cursor_both");
        return cursor.orElseGet(Cursor::getDefaultCursor);
    }

    @Override
    public float shadowOpacity() {
        return 0.6f;
    }

    @Override
    public int animFPS() {
        return 60;
    }

    @Override
    public int scrollThumbSize() {
        return 10;
    }

    @Override
    public int shadowOffsetX() {
        return 5;
    }

    @Override
    public int shadowOffsetY() {
        return 5;
    }

    @Override
    public int shadowOverfill() {
        return 0;
    }

    @Override
    public int shadowSize() {
        return 6;
    }

    @Override
    public int toolTipHeight() {
        return new JTextArea().getFontMetrics(MCon.fontToolTip()).getHeight() + 2;
    }

    @Override
    public short defaultGap() {
        return 15;
    }

    @Override
    public short standardHeight() {
        return 30;
    }
}

