/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.schemes.def;

import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MTable;
import de.maggicraft.mgui.comp.MTableUtil;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.schemes.types.MSchemeStyle;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.MScrollPaneStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MDefaultStyle
implements MSchemeStyle {
    @Override
    public void styleFrame(final @NotNull JFrame pFrame) {
        pFrame.getContentPane().setBackground(MCon.colorFrame());
        pFrame.setIconImages(MCon.windowIcons());
        pFrame.addKeyListener(new KeyAdapter(){
            boolean released = true;

            @Override
            public void keyReleased(KeyEvent pEvent) {
                this.released = true;
            }

            @Override
            public void keyPressed(@NotNull KeyEvent pEvent) {
                if (this.released && pEvent.getKeyCode() == 122) {
                    if (pFrame.getExtendedState() == 0) {
                        pFrame.setExtendedState(6);
                    } else {
                        pFrame.setExtendedState(0);
                    }
                    this.released = false;
                }
            }
        });
    }

    @Override
    public void styleView(@NotNull JLayeredPane pView) {
        pView.setFocusable(false);
        pView.setLayout(null);
        pView.setOpaque(true);
        pView.setBackground(MCon.colorFrame());
    }

    @Override
    public void styleScroll(@NotNull JScrollPane pPane) {
        MScrollPaneStyle.styleScroll(pPane);
    }

    @Override
    public void styleSplit(final @NotNull JSplitPane pSplit) {
        pSplit.setUI(new BasicSplitPaneUI(){

            @Override
            @NotNull
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border pBorder) {
                    }

                    @Override
                    public void paint(@NotNull Graphics pG) {
                        super.paint(pG);
                        pG.setColor(pSplit.getForeground());
                        pG.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                };
            }
        });
        pSplit.setContinuousLayout(true);
        pSplit.setBorder(null);
        BasicSplitPaneDivider dividerContainer = (BasicSplitPaneDivider)pSplit.getComponent(2);
        dividerContainer.setDividerSize(6);
    }

    @Override
    public void styleButton(final @NotNull JButton pButton, boolean pIconBased) {
        if (pIconBased) {
            pButton.setBorder(null);
            pButton.setOpaque(false);
        } else {
            pButton.setBorder(MCon.borderFocus());
            pButton.setOpaque(true);
            pButton.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent pEvent) {
                    pButton.setBorderPainted(true);
                }

                @Override
                public void focusLost(FocusEvent pEvent) {
                    pButton.setBorderPainted(false);
                }
            });
        }
        pButton.setHorizontalTextPosition(0);
        pButton.setFont(MCon.fontButton());
        pButton.setContentAreaFilled(false);
        pButton.setBorderPainted(false);
        pButton.setFocusPainted(false);
    }

    @Override
    public void styleCombo(@NotNull JComboBox pCombo) {
        pCombo.setBorder(null);
        pCombo.setMaximumRowCount(10);
        pCombo.setFont(MCon.fontCombo());
        pCombo.setOpaque(false);
        BasicComboBoxUI ui = new BasicComboBoxUI(){

            @Override
            protected JButton createArrowButton() {
                return new BasicArrowButton(5, MCon.colorComboBackground(), MCon.colorComboText(), MCon.colorComboText(), MCon.colorComboText());
            }

            @Override
            protected ComboPopup createPopup() {
                return new BasicComboPopup(this.comboBox){

                    @Override
                    @NotNull
                    protected JScrollPane createScroller() {
                        JScrollPane pane = new JScrollPane();
                        MCon.styleScroll(pane);
                        pane.getViewport().setView(this.list);
                        this.list.addListSelectionListener(pEvent -> pane.repaint());
                        return pane;
                    }

                    @Override
                    public void paint(Graphics g) {
                        this.setBackground(Color.red);
                        super.paint(g);
                    }
                };
            }

            @Override
            public void paintCurrentValue(Graphics g, @NotNull Rectangle bounds, boolean hasFocus) {
                if (this.listBox != null) {
                    super.paintCurrentValue(g, bounds, hasFocus);
                }
            }

            public void setPopupVisible(JComboBox c, boolean v) {
                if (this.popup != null) {
                    super.setPopupVisible(c, v);
                }
            }
        };
        pCombo.setRenderer(new BasicComboBoxRenderer());
        pCombo.setUI(ui);
        ((BasicComboBoxRenderer)pCombo.getRenderer()).setBorder(new EmptyBorder(0, 5, 0, 5));
    }

    @Override
    public void styleEditor(@NotNull JEditorPane pEditor) {
        pEditor.setContentType("text/html");
        pEditor.setEditable(false);
        pEditor.setOpaque(false);
        pEditor.setFocusable(false);
        pEditor.setFont(MCon.fontEditor());
        if (pEditor instanceof MEditor) {
            ((MEditor)pEditor).updateColor();
        }
    }

    @Override
    public void styleField(@NotNull JTextField pField) {
        pField.setFont(MCon.fontFieldPlaceholder());
        pField.setBorder(MCon.borderField());
    }

    @Override
    public void styleLabel(JLabel pLabel) {
    }

    @Override
    public void styleProgress(@NotNull JProgressBar pProgress) {
        pProgress.setForeground(MCon.colorProgressForeground());
        pProgress.setBackground(MCon.colorProgressBackground());
        pProgress.setFont(MCon.fontText());
        pProgress.setBorderPainted(false);
        pProgress.setStringPainted(true);
    }

    @Override
    public void styleRadio(@NotNull JRadioButton pRadio) {
        pRadio.setFont(MCon.fontRadio());
        pRadio.setBorderPainted(false);
        pRadio.setBorder(MCon.borderFocus());
        pRadio.setFocusPainted(false);
        pRadio.setOpaque(false);
        pRadio.setIcon(MCon.iconRadio());
        pRadio.setSelectedIcon(MCon.iconRadioSelected());
        pRadio.setRolloverIcon(MCon.iconRadioRollover());
        pRadio.setDisabledIcon(MCon.iconRadioDisabled());
        pRadio.setDisabledSelectedIcon(MCon.iconRadioDisabledSelected());
    }

    @Override
    public void styleSlider(@NotNull JSlider pSlider) {
        pSlider.setPaintTicks(true);
        pSlider.setSnapToTicks(true);
        pSlider.setBorder(null);
        pSlider.setOpaque(false);
        pSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        pSlider.setFont(MCon.fontText());
        BasicSliderUI ui = new BasicSliderUI(pSlider){

            @Override
            protected Color getShadowColor() {
                return Color.WHITE.darker();
            }

            @Override
            protected Color getHighlightColor() {
                return Color.WHITE.darker();
            }

            @Override
            protected Color getFocusColor() {
                return Color.WHITE.darker();
            }

            @Override
            public void paintTrack(@NotNull Graphics g) {
                Rectangle trackBounds = this.trackRect;
                if (this.slider.getOrientation() == 0) {
                    int cy = trackBounds.height / 2 - 2;
                    int cw = trackBounds.width;
                    g.translate(trackBounds.x, trackBounds.y + cy);
                    g.setColor(this.getShadowColor());
                    g.drawLine(0, 0, cw - 1, 0);
                    g.drawLine(0, 1, 0, 2);
                    g.setColor(this.getHighlightColor());
                    g.drawLine(0, 3, cw, 3);
                    g.drawLine(cw, 0, cw, 3);
                    g.setColor(Color.WHITE);
                    g.drawLine(1, 1, cw - 2, 1);
                    g.translate(-trackBounds.x, -(trackBounds.y + cy));
                } else {
                    int cx = trackBounds.width / 2 - 2;
                    int ch = trackBounds.height;
                    g.translate(trackBounds.x + cx, trackBounds.y);
                    g.setColor(this.getShadowColor());
                    g.drawLine(0, 0, 0, ch - 1);
                    g.drawLine(1, 0, 2, 0);
                    g.setColor(this.getHighlightColor());
                    g.drawLine(3, 0, 3, ch);
                    g.drawLine(0, ch, 3, ch);
                    g.setColor(Color.WHITE);
                    g.drawLine(1, 1, 1, ch - 2);
                    g.translate(-(trackBounds.x + cx), -trackBounds.y);
                }
            }

            @Override
            public void paintFocus(Graphics g) {
            }
        };
        pSlider.setUI(ui);
    }

    @Override
    public void styleSpinner(@NotNull JSpinner pSpinner) {
        Util.registerLookFeel(pSpinner);
        pSpinner.setFont(MCon.fontText());
    }

    @Override
    public void styleSwitcher(@NotNull JCheckBox pSwitcher) {
        pSwitcher.setFont(MCon.fontSwitcher());
        pSwitcher.setBorderPainted(false);
        pSwitcher.setBorder(MCon.borderFocus());
        pSwitcher.setFocusPainted(false);
        pSwitcher.setOpaque(false);
        pSwitcher.setIcon(MCon.iconSwitcher());
        pSwitcher.setSelectedIcon(MCon.iconSwitcherSelected());
        pSwitcher.setRolloverIcon(MCon.iconSwitcherRollover());
        pSwitcher.setDisabledIcon(MCon.iconSwitcherDisabled());
        pSwitcher.setDisabledSelectedIcon(MCon.iconSwitcherDisabledSelected());
    }

    @Override
    public void styleTable(@NotNull JTable pTable) {
        if (pTable instanceof MTable) {
            pTable.setModel(((MTable)pTable).createTableModel());
            pTable.getTableHeader().setColumnModel(pTable.getColumnModel());
        }
        pTable.setDefaultRenderer(String.class, new MTableUtil.MStringCellRenderer(pTable));
        pTable.setDefaultRenderer(Boolean.class, new MTableUtil.MBooleanCellRenderer());
        pTable.setDefaultEditor(Boolean.class, new MTableUtil.MBooleanCellEditor());
        pTable.setIntercellSpacing(new Dimension(0, 0));
        pTable.setFont(MCon.fontTableText());
        pTable.getTableHeader().setFont(MCon.fontTableHeader());
    }

    @Override
    public void styleText(@NotNull JTextComponent pText) {
        pText.setFont(MCon.fontText());
        pText.setOpaque(false);
        pText.setEditable(false);
        pText.setFocusable(false);
        if (pText instanceof JTextArea) {
            JTextArea text = (JTextArea)pText;
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
        }
    }

    @Override
    public void styleToggleButton(@NotNull JToggleButton pToggleButton) {
        pToggleButton.setForeground(MCon.colorButtonText());
        pToggleButton.setFont(MCon.fontButton());
        pToggleButton.setBorder(MCon.borderFocus());
        pToggleButton.setOpaque(true);
        pToggleButton.setContentAreaFilled(false);
        pToggleButton.setHorizontalTextPosition(0);
        pToggleButton.setBorderPainted(false);
        pToggleButton.setFocusPainted(false);
    }

    @Override
    public void styleToggleButtonIcon(@NotNull JToggleButton pToggleButton, @NotNull Icon pIcon) {
        Dimension size = new Dimension(pIcon.getIconWidth(), pIcon.getIconHeight());
        pToggleButton.setPreferredSize(size);
        pToggleButton.setContentAreaFilled(false);
        pToggleButton.setBorderPainted(false);
        pToggleButton.setBorder(null);
        pToggleButton.setFocusPainted(false);
        pToggleButton.setOpaque(false);
        pToggleButton.setForeground(MCon.colorButtonIconText());
        pToggleButton.setFont(MCon.fontButton());
        pToggleButton.setHorizontalTextPosition(0);
    }

    @Override
    public void styleTitle(@NotNull MTitle pTitle) {
        pTitle.setFont(MCon.fontTitle());
        pTitle.setForeground(MCon.colorTitleText());
        pTitle.setBackground(MCon.colorTitleLine());
        pTitle.getTextComp().setLineWrap(false);
        pTitle.getLabel().setOpaque(true);
    }

    @Override
    @Contract(value="_ -> new")
    @NotNull
    public Point posToolTip(@NotNull ITippable pComp) {
        MTip tip = pComp.getTip();
        int posY = -tip.getHeight() - 7;
        if (pComp.getY() + posY < MCon.defaultGap()) {
            posY = pComp.getHeight() + 5;
        }
        int posX = (pComp.getWidth() - tip.getWidth()) / 2;
        return new Point(posX, posY);
    }
}

