/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.schemes.types;

import de.maggicraft.mgui.schemes.MCon;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public abstract class MSchemeFont {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ITALIC_BOLD = 3;

    @NotNull
    public abstract String fontName();

    @NotNull
    public abstract Font fontButton();

    @NotNull
    public abstract Font fontCombo();

    @NotNull
    public abstract Font fontEditor();

    @NotNull
    public abstract Font fontField();

    @NotNull
    public abstract Font fontFieldPlaceholder();

    @NotNull
    public abstract Font fontRadio();

    @NotNull
    public abstract Font fontSwitcher();

    @NotNull
    public abstract Font fontTableHeader();

    @NotNull
    public abstract Font fontTableText();

    @NotNull
    public abstract Font fontText();

    @NotNull
    public abstract Font fontTitle();

    @NotNull
    public abstract Font fontMenu();

    @NotNull
    public abstract Font fontToolTip();

    public static Font font(int pSize) {
        return new Font(MCon.fontName(), 0, pSize);
    }

    public static Font font(String pName, int pSize) {
        return new Font(pName, 0, pSize);
    }

    public static Font font(int pSize, int pStyle) {
        return new Font(MCon.fontName(), pStyle, pSize);
    }

    public static Font font(String pName, int pSize, int pStyle) {
        return new Font(pName, pStyle, pSize);
    }

    public static Font font(Font pFont, int pStyle) {
        return new Font(pFont.getName(), pStyle, pFont.getSize());
    }

    public static Font fontUnderline(Font pFont) {
        HashMap<TextAttribute, Serializable> map = new HashMap<TextAttribute, Serializable>();
        map.put(TextAttribute.FONT, pFont);
        map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        return Font.getFont(map);
    }

    public static FontMetrics getMetrics(Font pFont) {
        return new JTextArea().getFontMetrics(pFont);
    }
}

