/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.settings;

import de.maggicraft.mcommons.filter.types.MFilters;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.settings.ISetting;
import de.maggicraft.mcommons.settings.MListSetting;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.comp.MRadio;
import de.maggicraft.mgui.comp.MSwitcher;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mioutil.json.IUniqueID;
import javax.swing.ButtonGroup;
import org.jetbrains.annotations.NotNull;

public final class MSettingGui {
    private MSettingGui() {
    }

    @NotNull
    public static MSwitcher switcherBool(@NotNull ISetting<Boolean> pSetting, @NotNull MMPos pPos) {
        return MSettingGui.switcherBool(pSetting, pPos, MSettingGui.getLang(pSetting.getUID()));
    }

    @NotNull
    public static MSwitcher switcherBool(@NotNull ISetting<Boolean> pSetting, @NotNull MMPos pPos, @NotNull String pText) {
        MSwitcher switcher = new MSwitcher(pPos, (boolean)pSetting.getValue()).text(pText);
        switcher.addItemListener(pEvent -> pSetting.setValue(switcher.isSelected()));
        return switcher;
    }

    @NotNull
    public static MField fieldText(@NotNull ISetting<String> pSetting, @NotNull MMPos pPos) {
        return MSettingGui.fieldText(pSetting, pPos, MSettingGui.getLang(pSetting.getUID()));
    }

    @NotNull
    public static MField fieldText(@NotNull ISetting<String> pSetting, @NotNull MMPos pPos, @NotNull String pText) {
        MField field = new MField(pPos).text(pSetting.getValue()).tip(new MTip(pText));
        field.addListener(pEvent -> pSetting.setValue(field.getText()));
        return field;
    }

    @NotNull
    public static MField fieldInt(@NotNull ISetting<Integer> pSetting, @NotNull MMPos pPos) {
        return MSettingGui.fieldInt(pSetting, pPos, MSettingGui.getLang(pSetting.getUID()));
    }

    @NotNull
    public static MField fieldInt(@NotNull ISetting<Integer> pSetting, @NotNull MMPos pPos, @NotNull String pText) {
        MField field = new MField(pPos).text(Integer.toString(pSetting.getValue())).tip(new MTip(pText));
        field.filter(MFilters.FILTER_INTEGER);
        field.addListener(pEvent -> pSetting.setValue(field.getInt()));
        return field;
    }

    @NotNull
    public static MRadio[] radioOptions(@NotNull MListSetting pSetting, @NotNull MMPos pPos, @NotNull String pRel) {
        return MSettingGui.radioOptions(pSetting, pPos, pRel, MSettingGui.getText(pSetting));
    }

    @NotNull
    public static MRadio[] radioOptions(@NotNull MListSetting pSetting, @NotNull MMPos pPos, @NotNull String pRel, @NotNull String[] pText) {
        if (pText.length != pSetting.getOptions().length) {
            throw new IllegalArgumentException("too few arguments for setting" + pSetting.getUID());
        }
        String[] options = pSetting.getOptions();
        ButtonGroup group = new ButtonGroup();
        MRadio[] radios = new MRadio[options.length];
        for (int i = 0; i < options.length; ++i) {
            radios[i] = new MRadio(i == 0 ? pPos : MPos.pos(pRel, radios[i - 1]), group).text(pText[i]);
            String uniqueID = options[i];
            radios[i].setSelected(pSetting.isSameValue(uniqueID));
            radios[i].addListener(pEvent -> pSetting.setValue(uniqueID));
        }
        return radios;
    }

    @NotNull
    public static MRadio radioOption(@NotNull MListSetting pSetting, @NotNull MMPos pPos, @NotNull String pSelection, @NotNull ButtonGroup pGroup) {
        return MSettingGui.radioOption(pSetting, pPos, pSelection, pGroup, MSettingGui.getLang("se." + pSelection));
    }

    @NotNull
    public static MRadio radioOption(@NotNull MListSetting pSetting, @NotNull MMPos pPos, @NotNull String pSelection, @NotNull ButtonGroup pGroup, @NotNull String pText) {
        MRadio radio = new MRadio(pPos, pGroup).text(pText);
        radio.setSelected(pSetting.isSameValue(pSelection));
        radio.addListener(pEvent -> pSetting.setValue(pSelection));
        return radio;
    }

    @NotNull
    public static MCombo compOptions(@NotNull MListSetting pSetting, @NotNull MMPos pPos) {
        return MSettingGui.compOptions(pSetting, pPos, MSettingGui.getText(pSetting));
    }

    @NotNull
    public static MCombo compOptions(@NotNull MListSetting pSetting, @NotNull MMPos pPos, @NotNull String[] pTexts) {
        String[] options = pSetting.getOptions();
        if (pTexts.length != options.length) {
            throw new IllegalArgumentException("too few arguments for setting" + pSetting.getUID());
        }
        MCombo combo = new MCombo(pPos).text(pTexts);
        combo.setSelectedIndex(pSetting.getSelectedIndex());
        combo.addListener(pEvent -> pSetting.setValue(options[combo.getSelectedIndex()]));
        return combo;
    }

    private static String[] getText(MListSetting pSetting) {
        String[] options = pSetting.getOptions();
        String[] texts = new String[options.length];
        for (int i = 0; i < texts.length; ++i) {
            texts[i] = MSettingGui.getLang(options[i]);
        }
        return texts;
    }

    private static String getLang(IUniqueID<String> pUniqueID) {
        return MSettingGui.getLang(pUniqueID.getUID());
    }

    private static String getLang(String pUniqueID) {
        return MLangManager.get("se." + pUniqueID);
    }
}

