/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.util;

import de.maggicraft.mcommons.util.MTuple;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mlog.MLog;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImgUtil {
    private ImgUtil() {
    }

    @NotNull
    public static URL getGUIIconURL(@NotNull String pName) {
        URL url = ImgUtil.class.getResource(MCon.guiIconPath() + pName + ".png");
        if (url == null) {
            throw new NullPointerException("invalid url: " + MCon.guiIconPath() + pName + ".png");
        }
        return url;
    }

    public static URL getAppIconURL(@NotNull String pName) {
        URL url = ImgUtil.class.getResource(MCon.appIconPath() + pName + ".png");
        if (url == null) {
            throw new NullPointerException("invalid url: " + MCon.appIconPath() + pName + ".png");
        }
        return url;
    }

    @NotNull
    public static ImageIcon getGUIIcon(@NotNull String pName) {
        try {
            return new ImageIcon(ImgUtil.getGUIIconURL(pName));
        }
        catch (NullPointerException pE) {
            throw new NullPointerException("name: " + pName + ", url: " + ImgUtil.getGUIIconURL(pName));
        }
    }

    @NotNull
    public static ImageIcon getAppIcon(@NotNull String pName) {
        try {
            return new ImageIcon(ImgUtil.getAppIconURL(pName));
        }
        catch (NullPointerException pE) {
            throw new NullPointerException("name: " + pName + ", url: " + ImgUtil.getAppIconURL(pName));
        }
    }

    public static Image getImg(@NotNull Icon pIcon) {
        if (pIcon instanceof ImageIcon) {
            return ((ImageIcon)pIcon).getImage();
        }
        BufferedImage image = new BufferedImage(pIcon.getIconWidth(), pIcon.getIconHeight(), 1);
        pIcon.paintIcon(null, image.getGraphics(), 0, 0);
        return image;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ImageIcon getImg(@NotNull Image pImage) {
        return new ImageIcon(pImage);
    }

    @NotNull
    public static Optional<BufferedImage> getGUIBuffered(@NotNull String pName) {
        try {
            return Optional.of(ImageIO.read(ImgUtil.getGUIIconURL(pName)));
        }
        catch (IOException pE) {
            MLog.log(pE);
            return Optional.empty();
        }
    }

    @NotNull
    public static Optional<BufferedImage> getAppBuffered(@NotNull String pName) {
        try {
            return Optional.of(ImageIO.read(ImgUtil.getAppIconURL(pName)));
        }
        catch (IOException pE) {
            MLog.log(pE);
            return Optional.empty();
        }
    }

    @NotNull
    public static BufferedImage getBuffered(@NotNull File pFile) {
        try {
            return ImageIO.read(pFile);
        }
        catch (IOException pE) {
            MLog.log(pE);
            throw new IllegalArgumentException("null buffered for: " + pFile.getAbsolutePath());
        }
    }

    @NotNull
    public static BufferedImage getBuffered(@NotNull Icon pIcon) {
        BufferedImage image = new BufferedImage(pIcon.getIconWidth(), pIcon.getIconHeight(), 1);
        image.getGraphics();
        pIcon.paintIcon(null, image.getGraphics(), 0, 0);
        return image;
    }

    @NotNull
    public static BufferedImage getBuffered(@NotNull Image pImg) {
        if (pImg instanceof BufferedImage) {
            return (BufferedImage)pImg;
        }
        BufferedImage image = new BufferedImage(pImg.getWidth(null), pImg.getHeight(null), 2);
        Graphics2D g2 = image.createGraphics();
        g2.drawImage(pImg, 0, 0, null);
        g2.dispose();
        return image;
    }

    @NotNull
    public static BufferedImage makeColorChanged(@NotNull BufferedImage pBuffered, @NotNull Color pColor) {
        int red = pColor.getRed();
        int green = pColor.getGreen();
        int blue = pColor.getBlue();
        BufferedImage output = new BufferedImage(pBuffered.getWidth(), pBuffered.getHeight(), 2);
        for (int x = 0; x < pBuffered.getWidth(); ++x) {
            for (int y = 0; y < pBuffered.getHeight(); ++y) {
                output.setRGB(x, y, ImgUtil.getColor(pBuffered.getRGB(x, y), red, green, blue));
            }
        }
        return output;
    }

    private static int getColor(int pRGB, int pRed, int pGreen, int pBlue) {
        return (pRGB >> 24 & 0xFF) << 24 | (pRed & 0xFF) << 16 | (pGreen & 0xFF) << 8 | pBlue & 0xFF;
    }

    @NotNull
    public static BufferedImage makeFlipped(@NotNull BufferedImage pBuffered) {
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(-1.0, 1.0));
        at.concatenate(AffineTransform.getTranslateInstance(-pBuffered.getWidth(), 0.0));
        return ImgUtil.makeTransformed(pBuffered, at);
    }

    @NotNull
    private static BufferedImage makeTransformed(@NotNull BufferedImage pBuffered, @NotNull AffineTransform pTransform) {
        BufferedImage output = new BufferedImage(pBuffered.getWidth(), pBuffered.getHeight(), 2);
        Graphics2D g2 = output.createGraphics();
        g2.transform(pTransform);
        g2.drawImage((Image)pBuffered, 0, 0, null);
        g2.dispose();
        return output;
    }

    @NotNull
    public static BufferedImage makeRotated(@NotNull BufferedImage pBuffered, double pRotation) {
        AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians(pRotation), (float)pBuffered.getWidth() / 2.0f, (float)pBuffered.getHeight() / 2.0f);
        return ImgUtil.makeTransformed(pBuffered, new AffineTransformOp(tx, 2));
    }

    @NotNull
    public static BufferedImage makeTransformed(BufferedImage pBuffered, @NotNull AffineTransformOp pTransformOp) {
        BufferedImage output = new BufferedImage(pBuffered.getWidth(), pBuffered.getHeight(), 2);
        Graphics2D g2 = output.createGraphics();
        g2.drawImage((Image)pTransformOp.filter(pBuffered, null), 0, 0, null);
        g2.dispose();
        return output;
    }

    @NotNull
    public static BufferedImage makeCircle(@NotNull BufferedImage pBuffered) {
        return ImgUtil.makeShaped(pBuffered, new Ellipse2D.Double(0.0, 0.0, pBuffered.getWidth(), pBuffered.getHeight()));
    }

    @NotNull
    public static BufferedImage makeRound(@NotNull BufferedImage pBuffered, int pRadius) {
        return ImgUtil.makeShaped(pBuffered, new RoundRectangle2D.Double(0.0, 0.0, pBuffered.getWidth(), pBuffered.getHeight(), pRadius, pRadius));
    }

    @NotNull
    public static BufferedImage makeShaped(BufferedImage pBuffered, @NotNull Shape pShape) {
        BufferedImage output = new BufferedImage((int)pShape.getBounds().getWidth(), (int)pShape.getBounds().getHeight(), 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(pShape);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)pBuffered, 0, 0, null);
        g2.dispose();
        return output;
    }

    @NotNull
    public static ImageIcon makePropScaled(@NotNull ImageIcon pIcon, int pNewWidth, int pNewHeight) {
        MTuple<Integer, Integer> scales = ImgUtil.scales(pNewWidth, pNewHeight, pIcon.getIconWidth(), pIcon.getIconHeight());
        return ImgUtil.makeScaled(pIcon, (int)scales.getA(), (int)scales.getB());
    }

    @NotNull
    public static ImageIcon makeScaled(@NotNull ImageIcon pIcon, int pNewWidth, int pNewHeight) {
        if (pNewWidth <= 0) {
            pNewWidth = 1;
        }
        if (pNewHeight <= 0) {
            pNewHeight = 1;
        }
        return new ImageIcon(pIcon.getImage().getScaledInstance(pNewWidth, pNewHeight, 4));
    }

    @NotNull
    public static BufferedImage makePropScaled(@NotNull BufferedImage pImg, int pNewWidth, int pNewHeight) {
        MTuple<Integer, Integer> scales = ImgUtil.scales(pNewWidth, pNewHeight, pImg.getWidth(), pImg.getHeight());
        return ImgUtil.makeScaled(pImg, (int)scales.getA(), (int)scales.getB());
    }

    private static MTuple<Integer, Integer> scales(int pNewWidth, int pNewHeight, int pImgWidth, int pImgHeight) {
        double ratioWidth = (double)pNewWidth / (double)pImgWidth;
        double ratioHeight = (double)pNewHeight / (double)pImgHeight;
        double ratio = Math.min(ratioWidth, ratioHeight);
        pNewWidth = Math.max(1, (int)((double)pImgWidth * ratio));
        pNewHeight = Math.max(1, (int)((double)pImgHeight * ratio));
        return new MTuple<Integer, Integer>(pNewWidth, pNewHeight);
    }

    @NotNull
    public static BufferedImage makeScaled(@NotNull BufferedImage pImg, int pNewWidth, int pNewHeight) {
        BufferedImage img = new BufferedImage(pNewWidth, pNewHeight, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.drawImage(pImg.getScaledInstance(pNewWidth, pNewHeight, 4), 0, 0, null);
        g2d.dispose();
        return img;
    }

    @NotNull
    public static BufferedImage makeCombined(BufferedImage ... pLayers) {
        return ImgUtil.makeCombined(false, pLayers);
    }

    @NotNull
    public static BufferedImage makeCombined(boolean pCentered, BufferedImage ... pLayers) {
        int width = 0;
        int height = 0;
        for (BufferedImage layer : pLayers) {
            width = Math.max(width, layer.getWidth());
            height = Math.max(height, layer.getHeight());
        }
        BufferedImage combined = new BufferedImage(width, height, 2);
        Graphics g = combined.getGraphics();
        for (BufferedImage layer : pLayers) {
            int x = 0;
            int y = 0;
            if (pCentered) {
                x = (width - layer.getWidth()) / 2;
                y = (height - layer.getHeight()) / 2;
            }
            g.drawImage(layer, x, y, null);
        }
        return combined;
    }
}

