/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.util;

import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListener;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.view.MDialog;
import de.maggicraft.mgui.view.MFrame;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class MDebugColor
extends MCompListener {
    public static final Map<Integer, Color> COLORS = new HashMap<Integer, Color>();
    private static MDebugColor sDebugColor;

    public static void activate() {
        sDebugColor = new MDebugColor();
        MCompListeners.addListener(sDebugColor);
    }

    public static void deactivate() {
        MCompListeners.removeListener(sDebugColor);
        sDebugColor = null;
    }

    @Override
    public void compInitialized(IComp pComp) {
        MDebugColor.debugComp(pComp, MDebugColor.getColor(pComp));
    }

    public static Color getColor(IComp pComp) {
        return MDebugColor.getColor(MDebugColor.getDepth(pComp));
    }

    public static int getDepth(IComp pComp) {
        MMPos pos;
        if (pComp instanceof MFrame || pComp instanceof MDialog) {
            return 0;
        }
        int depth = 0;
        IComp parent = pComp;
        do {
            ++depth;
            pos = parent.getPos();
            if (pos != null) continue;
            return depth;
        } while (!((parent = pos.getView()) instanceof MFrame) && !(parent instanceof MDialog));
        return depth;
    }

    public static Color getColor(int pDepth) {
        if (pDepth == 0) {
            return Color.WHITE;
        }
        return COLORS.computeIfPresent(pDepth, (pInteger, pColor) -> MDebugColor.getColor(pDepth - 1).darker());
    }

    public static void debugColor(MFrame pFrame) {
        MDebugColor.debugView(pFrame, Color.WHITE);
    }

    private static void debugView(IView pView, Color pColor) {
        MDebugColor.debugComp(pView, pColor);
        Color shade = pColor.darker();
        List<? extends IComp> comps = pView.getComps();
        for (IComp iComp : comps) {
            if (iComp instanceof IView) {
                MDebugColor.debugView((IView)iComp, shade);
                continue;
            }
            MDebugColor.debugComp(iComp, shade);
        }
    }

    private static void debugComp(IComp pComp, Color pColor) {
        if (pComp instanceof JComponent) {
            JComponent comp = (JComponent)((Object)pComp);
            comp.setBackground(pColor);
            comp.setOpaque(true);
        }
    }
}

