/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.util;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListener;
import de.maggicraft.mgui.listener.MCompListeners;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class MDebugInfo
extends MCompListener {
    private static MDebugInfo sDebugInfo;
    private static HashMap<IComp, String> sReferences;
    private boolean mKeyPressed;

    public MDebugInfo() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(pEvent -> {
            if (pEvent.getID() == 401) {
                if (pEvent.getKeyCode() == 17) {
                    this.mKeyPressed = true;
                }
            } else if (pEvent.getID() == 402 && pEvent.getKeyCode() == 17) {
                this.mKeyPressed = false;
            }
            return false;
        });
    }

    public static void activate() {
        sDebugInfo = new MDebugInfo();
        MCompListeners.addListener(sDebugInfo);
    }

    public static void deactivate() {
        MCompListeners.removeListener(sDebugInfo);
        sDebugInfo = null;
    }

    public static String getInfo(IComp pComp) {
        StringBuilder sb = new StringBuilder();
        sb.append(CCon.LINE_SEP);
        sb.append("name: ").append(pComp.getName()).append(" - class: ").append(pComp.getClass().getName()).append(CCon.LINE_SEP);
        sb.append("initialized: ").append(sReferences.get(pComp)).append(CCon.LINE_SEP);
        sb.append("Position").append(CCon.LINE_SEP);
        sb.append(pComp.getPos().getInfo());
        sb.append("x: ").append(pComp.getX()).append(", y: ").append(pComp.getY()).append(", width: ").append(pComp.getWidth()).append(", height: ").append(pComp.getHeight()).append(CCon.LINE_SEP);
        if (pComp instanceof Component) {
            Component comp = (Component)((Object)pComp);
            sb.append("pref - width: ").append(comp.getPreferredSize().width).append(", height: ").append(comp.getPreferredSize().height);
        }
        return sb.toString();
    }

    public static String getInitLocation(IComp pComp) {
        return sReferences.get(pComp);
    }

    @Override
    public void compInitialized(final IComp pComp) {
        this.initLocation(pComp);
        if (pComp instanceof JComponent) {
            JComponent comp = (JComponent)((Object)pComp);
            comp.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent pEvent) {
                    if (MDebugInfo.this.mKeyPressed) {
                        System.out.println(MDebugInfo.getInfo(pComp));
                    }
                }
            });
            comp.getInputMap().put(KeyStroke.getKeyStroke("F2"), "doSomething");
        }
    }

    private void initLocation(IComp pComp) {
        int i;
        String name = pComp.getClass().getName();
        Exception exception = new Exception();
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        String[] lines = writer.toString().split(CCon.LINE_SEP);
        for (i = 0; i < lines.length && !lines[i].contains(name); ++i) {
        }
        while (i < lines.length && lines[i].contains(name)) {
            ++i;
        }
        sReferences.put(pComp, lines[i]);
    }

    static {
        sReferences = new HashMap();
    }
}

