/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.util;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.util.MWindowManager;
import de.maggicraft.mgui.view.MFrame;
import de.maggicraft.mgui.view.util.IView;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MReflection {
    private MReflection() {
    }

    public static IComp retrieveComp(String pPath, @Nullable Class pClass) {
        String[] parts = pPath.split("/");
        List<MFrame> frames = MWindowManager.getFrames();
        for (MFrame frame : frames) {
            if (!frame.isUpdatable() || !parts[0].equals(frame.getName())) continue;
            return MReflection.retrieveComp(frame, pPath.substring(pPath.indexOf(47) + 1), pClass);
        }
        String className = " and " + (pClass == null ? "any class" : "class: " + pClass.getName());
        throw new IllegalArgumentException("no matching component for path: " + pPath + className);
    }

    public static IComp retrieveComp(@NotNull IView pView, @NotNull String pPath, @Nullable Class pClass) {
        Iterator<IComp> iterator;
        HashSet<IComp> comps = MReflection.retrieveComps(pView, pPath, pClass);
        String className = "";
        if (comps.size() != 1) {
            className = " and " + (pClass == null ? "any class" : "class: " + pClass.getName());
            if (comps.size() > 1) {
                throw new IllegalArgumentException("multiple matching components for path: " + pPath + className);
            }
        }
        if ((iterator = comps.iterator()).hasNext()) {
            IComp comp = iterator.next();
            return comp;
        }
        throw new IllegalArgumentException("no matching component for path: " + pPath + className);
    }

    @NotNull
    public static HashSet<IComp> retrieveComps(@NotNull IView pView, String pPath, Class pClass) {
        HashSet<IComp> matchingComps = new HashSet<IComp>();
        if (pPath.isEmpty() || pPath.equals("/")) {
            matchingComps.add(pView);
            return matchingComps;
        }
        HashSet<? extends IComp> level = new HashSet<IComp>(pView.getComps());
        String[] paths = pPath.split("/");
        for (int i = 0; i < paths.length; ++i) {
            HashSet<? extends IComp> nextLevel = new HashSet<IComp>();
            for (IComp iComp : level) {
                if (iComp.getName() == null || !iComp.getName().equals(paths[i])) continue;
                if (i == paths.length - 1) {
                    if (!MReflection.matches(pClass, iComp)) continue;
                    matchingComps.add(iComp);
                    continue;
                }
                if (!(iComp instanceof IView)) continue;
                nextLevel.addAll(((IView)iComp).getComps());
            }
            level = nextLevel;
        }
        return matchingComps;
    }

    public static boolean matches(@Nullable Class pClass, @NotNull Object pObject) {
        return pClass == null || pClass.isAssignableFrom(pObject.getClass());
    }

    public static void printNames(@NotNull IView pView) {
        LinkedList<String> names = MReflection.retrieveNames(pView);
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append(name).append(CCon.LINE_SEP);
        }
        System.out.println(sb);
    }

    @NotNull
    public static LinkedList<String> retrieveNames(@NotNull IView pView) {
        LinkedList<String> names = new LinkedList<String>();
        MReflection.retrieveNames(pView, names);
        return names;
    }

    public static void retrieveNames(@NotNull IView pView, @NotNull List<String> pNames) {
        for (IComp iComp : pView.getComps()) {
            if (iComp instanceof IView) {
                MReflection.retrieveNames((IView)iComp, pNames);
            }
            pNames.add(iComp.getName());
        }
    }

    public static void printPaths(@NotNull IView pView) {
        List<String> paths = MReflection.retrievePaths(pView);
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            sb.append(path).append(CCon.LINE_SEP);
        }
        System.out.println(sb);
    }

    @NotNull
    public static List<String> retrievePaths(@NotNull IView pView) {
        LinkedList<String> paths = new LinkedList<String>();
        MReflection.retrievePaths(pView, paths, pView.getName() + '/');
        return paths;
    }

    public static void retrievePaths(IComp pComp, @NotNull List<String> pPaths, String pPrefix) {
        if (pComp instanceof IView) {
            for (IComp iComp : ((IView)pComp).getComps()) {
                MReflection.retrievePaths(iComp, pPaths, pPrefix + iComp.getName() + '/');
            }
        }
        pPaths.add(pPrefix + MReflection.getClassName(pComp.getClass()));
    }

    public static String getClassName(Class pClass) {
        return " (" + pClass.getName() + ')';
    }
}

