/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.util;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.Util;
import java.awt.FontMetrics;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MTip {
    private static FontMetrics sMetrics;
    private String mText;
    private int mWidth;
    private int mHeight;
    private int mLines = 1;

    public MTip() {
    }

    public MTip(@NotNull String pText) {
        this.mText = pText;
    }

    public MTip(int pLines) {
        this.mLines = pLines;
    }

    public MTip(@NotNull String pText, int pLines) {
        this.mText = pText;
        this.mLines = pLines;
    }

    public void tip(@NotNull ITippable pComp) {
        if (this.mText == null) {
            throw new NullPointerException("mText is null");
        }
        this.toolTip(pComp);
    }

    public void tip(@NotNull ITippable pComp, @NotNull String pTitle) {
        this.mText = MLangManager.get(pTitle);
        this.toolTip(pComp);
    }

    public void updateLang(@NotNull ITippable pComp, @NotNull String pTitle) {
        this.tip(pComp, pTitle);
    }

    private void toolTip(@NotNull ITippable pComp) {
        String[] lines = this.mLines == 1 ? new String[]{this.mText} : MTip.wrapTextLines(this.mText, sMetrics, this.mLines);
        int calc = 17 + this.mText.length() + 3 * lines.length;
        StringBuilder sb = new StringBuilder(calc).append("<html><center>");
        for (String line : lines) {
            sb.append(line).append("<br>");
        }
        String toolTip = sb.append("</center></html>").toString();
        pComp.setToolTipText(toolTip);
        this.mWidth = Util.getWidth(MCon.fontToolTip(), lines) + 8;
        this.mHeight = lines.length * sMetrics.getHeight();
    }

    @NotNull
    private static String[] wrapTextLines(@NotNull String pText, @NotNull FontMetrics pMetrics, int pQuantity) {
        if (pQuantity == 1) {
            return new String[]{pText};
        }
        String[] parts = pText.split(" ");
        String[] fractions = new String[pQuantity];
        int fraction = pMetrics.stringWidth(pText) / pQuantity;
        String lastText = null;
        int difOld = Integer.MAX_VALUE;
        int fractionCount = 1;
        int lastPart = 0;
        for (int i = 0; i < parts.length; ++i) {
            String text = MTip.foldParts(parts, lastPart, i);
            int difCur = fraction - pMetrics.stringWidth(text);
            if (difCur < 0) {
                difCur *= -1;
            }
            if (difCur >= difOld) {
                fractions[fractionCount - 1] = lastText;
                difOld = Integer.MAX_VALUE;
                lastPart = i--;
                if (++fractionCount != pQuantity) continue;
                fractions[pQuantity - 1] = MTip.foldParts(parts, lastPart, parts.length - 1);
                break;
            }
            difOld = difCur;
            lastText = text;
        }
        int j = 0;
        for (int i = fractions.length - 1; i >= 0 && fractions[i] == null; --i) {
            ++j;
        }
        if (j > 0) {
            return Arrays.copyOfRange(fractions, 0, fractions.length - j);
        }
        return fractions;
    }

    private static String foldParts(String[] pParts, int pStart, int pIteration) {
        StringBuilder sb = new StringBuilder();
        for (int i = pStart; i < pIteration + 1; ++i) {
            sb.append(pParts[i]).append(' ');
        }
        return sb.toString();
    }

    public static void setMetrics(FontMetrics pMetrics) {
        sMetrics = pMetrics;
    }

    public void setText(String pText) {
        this.mText = pText;
    }

    @NotNull
    public String getText() {
        return this.mText;
    }

    public int getLines() {
        return this.mLines;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }
}

